/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.jakarta.graphql;

import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.graphql.SentryGraphqlInstrumentation;
import io.sentry.graphql.SentrySubscriptionHandler;
import io.sentry.graphql22.SentryInstrumentation;
import io.sentry.spring.boot.jakarta.SentryProperties;
import io.sentry.spring.jakarta.graphql.SentryDataFetcherExceptionResolverAdapter;
import io.sentry.spring.jakarta.graphql.SentryGraphqlBeanPostProcessor;
import io.sentry.spring.jakarta.graphql.SentrySpringSubscriptionHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
public class SentryGraphql22AutoConfiguration {
    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean(name={"sentryInstrumentation"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public SentryInstrumentation sentryInstrumentationWebMvc(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring6GrahQLWebMVC");
        return this.createInstrumentation(sentryProperties, beforeSpanCallback, false);
    }

    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean(name={"sentryInstrumentation"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public SentryInstrumentation sentryInstrumentationWebflux(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring6GrahQLWebFlux");
        return this.createInstrumentation(sentryProperties, beforeSpanCallback, true);
    }

    private SentryInstrumentation createInstrumentation(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback, boolean captureRequestBody) {
        return new SentryInstrumentation((SentryGraphqlInstrumentation.BeforeSpanCallback)beforeSpanCallback.getIfAvailable(), (SentrySubscriptionHandler)new SentrySpringSubscriptionHandler(), captureRequestBody, sentryProperties.getGraphql().getIgnoredErrorTypes());
    }

    @Bean
    @Order(value=-2147483648)
    public SentryDataFetcherExceptionResolverAdapter exceptionResolverAdapter() {
        return new SentryDataFetcherExceptionResolverAdapter();
    }

    @Bean
    public static SentryGraphqlBeanPostProcessor graphqlBeanPostProcessor() {
        return new SentryGraphqlBeanPostProcessor();
    }
}

