/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.spring.webflux.SentryRequestResolver;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilter
implements WebFilter {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;

    public SentryWebFilter(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryRequestResolver = new SentryRequestResolver(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> this.hub.popScope()).doFirst(() -> {
            this.hub.pushScope();
            ServerHttpRequest request = serverWebExchange.getRequest();
            ServerHttpResponse response = serverWebExchange.getResponse();
            Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            this.hub.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)request.getMethodValue()), hint);
            this.hub.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        });
    }
}

