/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.mariadbv2.interceptors;

import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.database.config.DatabaseWriteProhibitionManager;
import io.sermant.database.controller.DatabaseController;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.database.utils.SqlParserUtils;
import io.sermant.mariadbv2.interceptors.AbstractMariadbV2Interceptor;
import java.util.List;

public class ExecuteBatchStmtInterceptor
extends AbstractMariadbV2Interceptor {
    private static final int PARAM_INDEX = 2;

    public ExecuteBatchStmtInterceptor() {
    }

    public ExecuteBatchStmtInterceptor(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    protected ExecuteContext doBefore(ExecuteContext context) {
        String database = this.getDataBaseInfo(context).getDatabaseName();
        if (!DatabaseWriteProhibitionManager.getMySqlProhibitionDatabases().contains(database)) {
            return context;
        }
        List sqlList = (List)context.getArguments()[2];
        for (String sql : sqlList) {
            if (!SqlParserUtils.isWriteOperation(sql)) continue;
            DatabaseController.disableDatabaseWriteOperation(database, context);
            return context;
        }
        return context;
    }
}

