/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.mariadbv2.utils;

import io.sermant.core.plugin.agent.declarer.InterceptDeclarer;
import io.sermant.core.plugin.agent.interceptor.Interceptor;
import io.sermant.core.plugin.agent.matcher.ClassMatcher;
import io.sermant.core.plugin.agent.matcher.MethodMatcher;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.mariadbv2.interceptors.ExecuteBatchStmtInterceptor;
import io.sermant.mariadbv2.interceptors.ExecuteInterceptor;
import io.sermant.mariadbv2.interceptors.ExecuteServerInterceptor;
import io.sermant.mariadbv2.interceptors.PrepareInterceptor;
import net.bytebuddy.matcher.ElementMatcher;

public class MariadbV2EnhancementHelper {
    private static final String QUERY_PROTOCOL_CLASS = "org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol";
    private static final String EXECUTE_QUERY_METHOD_NAME = "executeQuery";
    private static final String EXECUTE_BATCH_CLIENT_METHOD_NAME = "executeBatchClient";
    private static final String EXECUTE_BATCH_SERVER_METHOD_NAME = "executeBatchServer";
    private static final String EXECUTE_BATCH_STMT_METHOD_NAME = "executeBatchStmt";
    private static final String EXECUTE_PREPARED_QUERY_METHOD_NAME = "executePreparedQuery";
    private static final String PREPARE_METHOD_NAME = "prepare";
    private static final int FIRST_OVER_LOAD_METHOD_PARAM_COUNT = 3;
    private static final int SECOND_OVER_LOAD_METHOD_PARAM_COUNT = 4;
    private static final int THIRD_OVER_LOAD_METHOD_PARAM_COUNT = 5;

    private MariadbV2EnhancementHelper() {
    }

    public static ClassMatcher getQueryProtocolClassMatcher() {
        return ClassMatcher.nameEquals((String)QUERY_PROTOCOL_CLASS);
    }

    public static InterceptDeclarer[] getQueryProtocolInterceptDeclarers() {
        ExecuteInterceptor executeInterceptor = new ExecuteInterceptor();
        ExecuteServerInterceptor executeServerInterceptor = new ExecuteServerInterceptor();
        return new InterceptDeclarer[]{InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteQueryMethodMatcher(), (Interceptor[])new Interceptor[]{executeInterceptor}), InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchClientMethodMatcher(), (Interceptor[])new Interceptor[]{executeInterceptor}), InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchStmtMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteBatchStmtInterceptor()}), InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecutePreparedQueryMethodMatcher(), (Interceptor[])new Interceptor[]{executeServerInterceptor}), InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchServerMethodMatcher(), (Interceptor[])new Interceptor[]{executeServerInterceptor}), InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getPrepareMethodMatcher(), (Interceptor[])new Interceptor[]{new PrepareInterceptor()})};
    }

    public static InterceptDeclarer getExecuteQueryInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteInterceptor()});
    }

    public static InterceptDeclarer getExecuteQueryInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteInterceptor(handler)});
    }

    public static InterceptDeclarer getExecuteBatchClientInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchClientMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteInterceptor()});
    }

    public static InterceptDeclarer getExecuteBatchClientInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchClientMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteInterceptor(handler)});
    }

    public static InterceptDeclarer getExecuteBatchStmtInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchStmtMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteBatchStmtInterceptor()});
    }

    public static InterceptDeclarer getExecuteBatchStmtInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchStmtMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteBatchStmtInterceptor(handler)});
    }

    public static InterceptDeclarer getExecutePreparedQueryInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecutePreparedQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteServerInterceptor()});
    }

    public static InterceptDeclarer getExecutePreparedQueryInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecutePreparedQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteServerInterceptor(handler)});
    }

    public static InterceptDeclarer getExecuteBatchServerInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchServerMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteServerInterceptor()});
    }

    public static InterceptDeclarer getExecuteBatchServerInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getExecuteBatchServerMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecuteServerInterceptor(handler)});
    }

    public static InterceptDeclarer getPrepareInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getPrepareMethodMatcher(), (Interceptor[])new Interceptor[]{new PrepareInterceptor()});
    }

    public static InterceptDeclarer getPrepareInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV2EnhancementHelper.getPrepareMethodMatcher(), (Interceptor[])new Interceptor[]{new PrepareInterceptor(handler)});
    }

    private static MethodMatcher getExecuteQueryMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_QUERY_METHOD_NAME).and((ElementMatcher)MethodMatcher.paramCountEquals((int)3).or((ElementMatcher)MethodMatcher.paramCountEquals((int)4)).or((ElementMatcher)MethodMatcher.paramCountEquals((int)5)));
    }

    private static MethodMatcher getExecuteBatchStmtMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_BATCH_STMT_METHOD_NAME);
    }

    private static MethodMatcher getExecuteBatchClientMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_BATCH_CLIENT_METHOD_NAME);
    }

    private static MethodMatcher getExecutePreparedQueryMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_PREPARED_QUERY_METHOD_NAME);
    }

    private static MethodMatcher getExecuteBatchServerMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_BATCH_SERVER_METHOD_NAME);
    }

    private static MethodMatcher getPrepareMethodMatcher() {
        return MethodMatcher.nameEquals((String)PREPARE_METHOD_NAME);
    }
}

