/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.serverlessworkflow.generator.GeneratorUtils;
import jakarta.validation.ConstraintViolationException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.rules.SchemaRule;

class AllAnyOneOfSchemaRule
extends SchemaRule {
    private RuleFactory ruleFactory;
    private static final String REF = "$ref";
    private static final String PATTERN = "pattern";

    AllAnyOneOfSchemaRule(RuleFactory ruleFactory) {
        super(ruleFactory);
        this.ruleFactory = ruleFactory;
    }

    public JType apply(String nodeName, JsonNode schemaNode, JsonNode parent, JClassContainer generatableType, Schema schema) {
        JType javaType;
        Optional<JType> refType = this.refType(nodeName, schemaNode, parent, generatableType, schema);
        ArrayList<JTypeWrapper> oneOfTypes = new ArrayList<JTypeWrapper>();
        ArrayList<JTypeWrapper> allOfTypes = new ArrayList<JTypeWrapper>();
        this.unionType("oneOf", nodeName, schemaNode, parent, generatableType, schema, oneOfTypes);
        this.unionType("anyOf", nodeName, schemaNode, parent, generatableType, schema, oneOfTypes);
        this.unionType("allOf", nodeName, schemaNode, parent, generatableType, schema, allOfTypes);
        Collections.sort(oneOfTypes);
        if (schemaNode.has("enum")) {
            javaType = (JType)this.ruleFactory.getEnumRule().apply(nodeName, schemaNode, parent, (Object)generatableType, schema);
        } else if (!schemaNode.has("properties") && oneOfTypes.isEmpty() && allOfTypes.isEmpty() && refType.isPresent()) {
            javaType = refType.get();
        } else {
            JPackage container = generatableType.getPackage();
            javaType = (JType)this.ruleFactory.getTypeRule().apply(nodeName, schemaNode, parent, (Object)container, schema);
            if (javaType instanceof JDefinedClass) {
                javaType = this.populateAllOf(schema, this.populateRef((JDefinedClass)javaType, refType, schema), allOfTypes);
            }
            if (!oneOfTypes.isEmpty()) {
                try {
                    Optional<JType> commonType;
                    JDefinedClass unionClass;
                    if (javaType instanceof JDefinedClass) {
                        JDefinedClass clazz = (JDefinedClass)javaType;
                        if (clazz.methods().isEmpty()) {
                            unionClass = clazz;
                            commonType = Optional.empty();
                        } else {
                            unionClass = container._class(clazz.name() + "Union");
                            commonType = Optional.of(clazz);
                        }
                    } else {
                        unionClass = container._class(this.ruleFactory.getNameHelper().getUniqueClassName(nodeName, schemaNode, container));
                        commonType = Optional.empty();
                    }
                    javaType = this.populateOneOf(schema, unionClass, commonType, oneOfTypes);
                }
                catch (JClassAlreadyExistsException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            schema.setJavaType(javaType);
        }
        return javaType;
    }

    private JDefinedClass populateAllOf(Schema parentSchema, JDefinedClass definedClass, Collection<JTypeWrapper> allOfTypes) {
        return this.wrapAll(parentSchema, definedClass, Optional.empty(), allOfTypes, Optional.empty());
    }

    private JDefinedClass populateOneOf(Schema parentSchema, JDefinedClass definedClass, Optional<JType> commonType, Collection<JTypeWrapper> oneOfTypes) {
        JFieldVar valueField = definedClass.field(4, commonType.orElse((JType)definedClass.owner().ref(Object.class)), this.ruleFactory.getNameHelper().getPropertyName("value", null), null);
        definedClass._implements(definedClass.owner().ref("io.serverlessworkflow.api.OneOfValueProvider").narrow(valueField.type()));
        GeneratorUtils.implementInterface(definedClass, valueField);
        try {
            JDefinedClass serializer = this.generateSerializer(definedClass);
            definedClass.annotate(JsonSerialize.class).param("using", (JType)serializer);
        }
        catch (JClassAlreadyExistsException serializer) {
            // empty catch block
        }
        try {
            JDefinedClass deserializer = this.generateDeserializer(definedClass, oneOfTypes, "deserializeOneOf");
            definedClass.annotate(JsonDeserialize.class).param("using", (JType)deserializer);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            // empty catch block
        }
        return this.wrapAll(parentSchema, definedClass, commonType, oneOfTypes, Optional.of(valueField));
    }

    private JDefinedClass wrapAll(Schema parentSchema, JDefinedClass definedClass, Optional<JType> commonType, Collection<JTypeWrapper> types, Optional<JFieldVar> valueField) {
        ArrayList<JTypeWrapper> stringTypes = new ArrayList<JTypeWrapper>();
        for (JTypeWrapper unionType : types) {
            if (AllAnyOneOfSchemaRule.isStringType(unionType.getType())) {
                stringTypes.add(unionType);
                continue;
            }
            if (unionType.getType() instanceof JDefinedClass) {
                commonType.ifPresent(c -> ((JDefinedClass)unionType.getType())._extends((JClass)((JDefinedClass)c)));
            }
            this.wrapIt(parentSchema, definedClass, valueField, unionType.getType(), unionType.getNode());
        }
        if (!stringTypes.isEmpty()) {
            this.wrapStrings(parentSchema, definedClass, valueField, stringTypes);
        }
        return definedClass;
    }

    private JDefinedClass populateRef(JDefinedClass definedClass, Optional<JType> refType, Schema parentSchema) {
        refType.ifPresent(type -> {
            if (type instanceof JClass) {
                definedClass._extends((JClass)type);
            } else {
                this.wrapIt(parentSchema, definedClass, Optional.empty(), (JType)type, null);
            }
        });
        if (definedClass.constructors().hasNext() && definedClass.getConstructor(new JType[0]) == null) {
            definedClass.constructor(1);
        }
        return definedClass;
    }

    private static boolean isStringType(JType type) {
        return type.name().equals("String");
    }

    private JDefinedClass generateSerializer(JDefinedClass relatedClass) throws JClassAlreadyExistsException {
        JDefinedClass definedClass = GeneratorUtils.serializerClass(relatedClass);
        GeneratorUtils.fillSerializer(definedClass, relatedClass, (method, valueParam, genParam) -> method.body().staticInvoke(definedClass.owner().ref("io.serverlessworkflow.serialization.SerializeHelper"), "serializeOneOf").arg((JExpression)genParam).arg((JExpression)valueParam));
        return definedClass;
    }

    private JDefinedClass generateDeserializer(JDefinedClass relatedClass, Collection<JTypeWrapper> oneOfTypes, String methodName) throws JClassAlreadyExistsException {
        JDefinedClass definedClass = GeneratorUtils.deserializerClass(relatedClass);
        GeneratorUtils.fillDeserializer(definedClass, relatedClass, (method, parserParam) -> {
            JBlock body = method.body();
            body._return((JExpression)definedClass.owner().ref("io.serverlessworkflow.serialization.DeserializeHelper").staticInvoke(methodName).arg((JExpression)parserParam).arg(relatedClass.dotclass()).arg((JExpression)this.list(definedClass, oneOfTypes)));
        });
        return definedClass;
    }

    private JInvocation list(JDefinedClass definedClass, Collection<JTypeWrapper> list) {
        JInvocation result = definedClass.owner().ref(List.class).staticInvoke("of");
        list.forEach(c -> result.arg(((JClass)c.getType()).dotclass()));
        return result;
    }

    private void wrapIt(Schema parentSchema, JDefinedClass definedClass, Optional<JFieldVar> valueField, JType unionType, JsonNode node) {
        JFieldVar instanceField = this.getInstanceField(parentSchema, definedClass, unionType, node);
        JMethod method = this.getSetterMethod(definedClass, instanceField, node);
        method.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)this.setupMethod(definedClass, method, valueField, instanceField));
    }

    private JVar setupMethod(JDefinedClass definedClass, JMethod method, Optional<JFieldVar> valueField, JFieldVar instanceField) {
        JVar methodParam = method.param(instanceField.type(), instanceField.name());
        valueField.ifPresent(v -> {
            method.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)v), (JExpression)methodParam);
            method.annotate(definedClass.owner().ref("io.serverlessworkflow.serialization.OneOfSetter")).param("value", instanceField.type());
        });
        return methodParam;
    }

    private JMethod getSetterMethod(JDefinedClass definedClass, JFieldVar instanceField, JsonNode node) {
        String setterName = this.ruleFactory.getNameHelper().getSetterName(instanceField.name(), node);
        JMethod fluentMethod = definedClass.method(1, (JType)definedClass, setterName.replaceFirst("set", "with"));
        JBlock body = fluentMethod.body();
        body.assign((JAssignmentTarget)instanceField, (JExpression)fluentMethod.param(instanceField.type(), "value"));
        body._return(JExpr._this());
        return definedClass.method(1, (JType)definedClass.owner().VOID, setterName);
    }

    private void wrapStrings(Schema parentSchema, JDefinedClass definedClass, Optional<JFieldVar> valueField, Collection<JTypeWrapper> stringTypes) {
        Iterator<JTypeWrapper> iter = stringTypes.iterator();
        JTypeWrapper first = iter.next();
        String pattern = this.pattern(first.getNode(), parentSchema);
        if (pattern == null && iter.hasNext()) {
            pattern = ".*";
        }
        JFieldVar instanceField = this.getInstanceField(parentSchema, definedClass, first.getType(), first.getNode());
        JMethod setterMethod = this.getSetterMethod(definedClass, instanceField, first.getNode());
        JVar methodParam = this.setupMethod(definedClass, setterMethod, valueField, instanceField);
        JBlock body = setterMethod.body();
        if (pattern != null) {
            JConditional condition = body._if((JExpression)this.getPatternCondition(pattern, body, instanceField, methodParam, definedClass));
            condition._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)methodParam);
            while (iter.hasNext()) {
                JTypeWrapper item = iter.next();
                instanceField = this.getInstanceField(parentSchema, definedClass, item.getType(), item.getNode());
                pattern = this.pattern(item.getNode(), parentSchema);
                if (pattern == null) {
                    pattern = ".*";
                }
                condition = condition._elseif((JExpression)this.getPatternCondition(pattern, body, instanceField, methodParam, definedClass));
                condition._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)methodParam);
            }
            condition._else()._throw((JExpression)JExpr._new((JType)definedClass.owner()._ref(ConstraintViolationException.class)).arg((JExpression)definedClass.owner().ref(String.class).staticInvoke("format").arg("%s does not match any pattern").arg((JExpression)methodParam)).arg(JExpr._null()));
        } else {
            body.assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)methodParam);
        }
    }

    private JFieldVar getInstanceField(Schema parentSchema, JDefinedClass definedClass, JType type, JsonNode node) {
        JFieldVar instanceField = definedClass.field(4, type, this.ruleFactory.getNameHelper().getPropertyName(this.getTypeName(node, type, parentSchema), node));
        GeneratorUtils.getterMethod(definedClass, instanceField, this.ruleFactory.getNameHelper(), instanceField.name());
        return instanceField;
    }

    private static String getFromNode(JsonNode node, String fieldName) {
        JsonNode item;
        if (node != null && (item = node.get(fieldName)) != null) {
            return item.asText();
        }
        return null;
    }

    private JInvocation getPatternCondition(String pattern, JBlock body, JFieldVar instanceField, JVar instanceParam, JDefinedClass definedClass) {
        JFieldVar patternField = definedClass.field(28, Pattern.class, instanceField.name() + "_Pattern", (JExpression)definedClass.owner().ref(Pattern.class).staticInvoke("compile").arg(pattern));
        return JExpr.invoke((JExpression)JExpr.invoke((JExpression)patternField, (String)"matcher").arg((JExpression)instanceParam), (String)"matches");
    }

    private void unionType(String prefix, String nodeName, JsonNode schemaNode, JsonNode parent, JClassContainer generatableType, Schema parentSchema, Collection<JTypeWrapper> types) {
        if (schemaNode.has(prefix)) {
            int i = 0;
            for (JsonNode oneOf : (ArrayNode)schemaNode.get(prefix)) {
                String ref = parentSchema.getId().toString() + "/" + prefix + "/" + i++;
                Schema schema = this.ruleFactory.getSchemaStore().create(URI.create(ref), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
                types.add(new JTypeWrapper(schema.isGenerated() ? schema.getJavaType() : this.apply(nodeName, oneOf, parent, (JClassContainer)generatableType.getPackage(), schema), oneOf));
            }
        }
    }

    private Optional<JType> refType(String nodeName, JsonNode schemaNode, JsonNode parent, JClassContainer generatableType, Schema parentSchema) {
        if (schemaNode.has(REF)) {
            String ref = schemaNode.get(REF).asText();
            Schema schema = this.ruleFactory.getSchemaStore().create(parentSchema, ref, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            return Optional.of(schema.isGenerated() ? schema.getJavaType() : this.apply(this.nameFromRef(ref, nodeName), schema.getContent(), parent, generatableType, schema));
        }
        return Optional.empty();
    }

    private JsonNode schemaRef(JsonNode schemaNode, Schema parentSchema) {
        String ref = AllAnyOneOfSchemaRule.getFromNode(schemaNode, REF);
        return ref != null ? this.ruleFactory.getSchemaStore().create(parentSchema, ref, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters()).getContent() : null;
    }

    private String getTypeName(JsonNode node, JType type, Schema parentSchema) {
        String title = "title";
        String name = AllAnyOneOfSchemaRule.getFromNode(node, "title");
        if (name == null) {
            name = AllAnyOneOfSchemaRule.getFromNode(this.schemaRef(node, parentSchema), "title");
        }
        if (name == null) {
            name = type.name();
        }
        return name;
    }

    private String pattern(JsonNode node, Schema parentSchema) {
        String pattern = this.pattern(node);
        return pattern != null ? pattern : this.pattern(this.schemaRef(node, parentSchema));
    }

    private String pattern(JsonNode node) {
        Format format = Format.parse(AllAnyOneOfSchemaRule.getFromNode(node, "format"));
        return format != null ? format.pattern() : AllAnyOneOfSchemaRule.getFromNode(node, PATTERN);
    }

    private String nameFromRef(String ref, String nodeName) {
        String nameFromRef;
        if ("#".equals(ref)) {
            return nodeName;
        }
        if (!ref.contains("#")) {
            nameFromRef = Jsonschema2Pojo.getNodeName((String)ref, (GenerationConfig)this.ruleFactory.getGenerationConfig());
        } else {
            String[] nameParts = ref.split("[/\\#]");
            nameFromRef = nameParts[nameParts.length - 1];
        }
        try {
            return URLDecoder.decode(nameFromRef, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GenerationException("Failed to decode ref: " + ref, (Throwable)e);
        }
    }

    private static class JTypeWrapper
    implements Comparable<JTypeWrapper> {
        private final JType type;
        private final JsonNode node;

        public JTypeWrapper(JType type, JsonNode node) {
            this.type = type;
            this.node = node;
        }

        public JType getType() {
            return this.type;
        }

        public JsonNode getNode() {
            return this.node;
        }

        @Override
        public int compareTo(JTypeWrapper other) {
            return this.typeToNumber() - other.typeToNumber();
        }

        private int typeToNumber() {
            if (this.type.name().equals("Object")) {
                return 6;
            }
            if (this.type.name().equals("String")) {
                return this.node.has(AllAnyOneOfSchemaRule.PATTERN) || this.node.has(AllAnyOneOfSchemaRule.REF) ? 4 : 5;
            }
            if (this.type.isPrimitive()) {
                return 3;
            }
            if (this.type.isReference()) {
                return 2;
            }
            if (this.type.isArray()) {
                return 1;
            }
            return 0;
        }
    }

    private static enum Format {
        URI_TEMPLATE("^[A-Za-z][A-Za-z0-9+\\-.]*://.*");

        private final String pattern;

        private Format(String pattern) {
            this.pattern = pattern;
        }

        public static Format parse(String str) {
            if (str != null) {
                switch (str) {
                    case "uri-template": {
                        return URI_TEMPLATE;
                    }
                }
            }
            return null;
        }

        String pattern() {
            return this.pattern;
        }
    }
}

