/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.generator;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.IOException;
import org.jsonschema2pojo.util.NameHelper;

public class GeneratorUtils {
    public static final String SERIALIZE_HELPER_NAME = "io.serverlessworkflow.serialization.SerializeHelper";
    public static final String DESERIALIZE_HELPER_NAME = "io.serverlessworkflow.serialization.DeserializeHelper";
    public static final String ONE_OF_VALUE_PROVIDER_INTERFACE_NAME = "io.serverlessworkflow.api.OneOfValueProvider";
    public static final String SETTER_ANNOTATION_NAME = "io.serverlessworkflow.serialization.OneOfSetter";

    public static JDefinedClass serializerClass(JDefinedClass relatedClass) throws JClassAlreadyExistsException {
        return GeneratorUtils.createClass(relatedClass, JsonSerializer.class, "Serializer");
    }

    public static JDefinedClass deserializerClass(JDefinedClass relatedClass) throws JClassAlreadyExistsException {
        return GeneratorUtils.createClass(relatedClass, JsonDeserializer.class, "Deserializer");
    }

    public static JMethod implementInterface(JDefinedClass definedClass, JFieldVar valueField) {
        JMethod method = definedClass.method(1, valueField.type(), "get");
        method.annotate(Override.class);
        method.body()._return((JExpression)valueField);
        return method;
    }

    public static JMethod getterMethod(JDefinedClass definedClass, JFieldVar instanceField, NameHelper nameHelper, String name) {
        JMethod method = definedClass.method(1, instanceField.type(), nameHelper.getGetterName(name, instanceField.type(), null));
        method.body()._return((JExpression)instanceField);
        return method;
    }

    public static void fillSerializer(JDefinedClass definedClass, JDefinedClass relatedClass, SerializerFiller filler) {
        JMethod method = definedClass.method(1, Void.TYPE, "serialize");
        method.annotate(Override.class);
        method._throws(IOException.class);
        JVar valueParam = method.param((JType)relatedClass, "value");
        JVar genParam = method.param(JsonGenerator.class, "gen");
        method.param(SerializerProvider.class, "serializers");
        filler.accept(method, valueParam, genParam);
    }

    public static void fillDeserializer(JDefinedClass definedClass, JDefinedClass relatedClass, DeserializerFiller filler) {
        JMethod method = definedClass.method(1, (JType)relatedClass, "deserialize");
        method.annotate(Override.class);
        method._throws(IOException.class);
        JVar parserParam = method.param(JsonParser.class, "parser");
        method.param(DeserializationContext.class, "dctx");
        filler.accept(method, parserParam);
    }

    private static JDefinedClass createClass(JDefinedClass relatedClass, Class<?> serializerClass, String suffix) throws JClassAlreadyExistsException {
        JDefinedClass definedClass = relatedClass._package()._class(0, relatedClass.name() + suffix);
        definedClass._extends(definedClass.owner().ref(serializerClass).narrow((JClass)relatedClass));
        return definedClass;
    }

    private GeneratorUtils() {
    }

    @FunctionalInterface
    public static interface SerializerFiller {
        public void accept(JMethod var1, JVar var2, JVar var3);
    }

    @FunctionalInterface
    public static interface DeserializerFiller {
        public void accept(JMethod var1, JVar var2);
    }
}

