/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.serverlessworkflow.generator.GeneratorUtils;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.AdditionalPropertiesRule;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.NameHelper;

public class UnevaluatedPropertiesRule
extends AdditionalPropertiesRule
implements Rule<JDefinedClass, JDefinedClass> {
    private RuleFactory ruleFactory;

    public UnevaluatedPropertiesRule(RuleFactory ruleFactory) {
        super(ruleFactory);
        this.ruleFactory = ruleFactory;
    }

    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema schema) {
        JsonNode unevalutedNode = parent.get("unevaluatedProperties");
        if (unevalutedNode != null && unevalutedNode.isBoolean() && !unevalutedNode.asBoolean() || node == null && parent.has("properties")) {
            return jclass;
        }
        if (node != null && this.checkIntValue(parent, "maxProperties", 1) && this.checkIntValue(parent, "minProperties", 1)) {
            try {
                return this.addKeyValueFields(jclass, node, parent, nodeName, schema);
            }
            catch (JClassAlreadyExistsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return super.apply(nodeName, node, parent, jclass, schema);
    }

    private JDefinedClass addKeyValueFields(JDefinedClass jclass, JsonNode node, JsonNode parent, String nodeName, Schema schema) throws JClassAlreadyExistsException {
        JClass propertyType;
        NameHelper nameHelper = this.ruleFactory.getNameHelper();
        JType stringClass = jclass.owner()._ref(String.class);
        JFieldVar nameField = jclass.field(4, stringClass, nameHelper.getPropertyName("name", null));
        JMethod nameMethod = GeneratorUtils.getterMethod(jclass, nameField, nameHelper, "name");
        if (node != null && node.size() != 0) {
            Object pathToAdditionalProperties = schema.getId().getFragment() == null ? "#/additionalProperties" : "#" + schema.getId().getFragment() + "/additionalProperties";
            Schema additionalPropertiesSchema = this.ruleFactory.getSchemaStore().create(schema, (String)pathToAdditionalProperties, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            propertyType = (JType)this.ruleFactory.getSchemaRule().apply(nodeName + "Property", node, parent, (Object)jclass, additionalPropertiesSchema);
            additionalPropertiesSchema.setJavaTypeIfEmpty((JType)propertyType);
        } else {
            propertyType = jclass.owner().ref(Object.class);
        }
        JFieldVar valueField = jclass.field(4, (JType)propertyType, nameHelper.getPropertyName(propertyType.name(), null));
        JMethod valueMethod = GeneratorUtils.getterMethod(jclass, valueField, nameHelper, propertyType.name());
        jclass.annotate(JsonSerialize.class).param("using", (JType)this.generateSerializer(jclass, nameMethod, valueMethod));
        jclass.annotate(JsonDeserialize.class).param("using", (JType)this.generateDeserializer(jclass, (JType)propertyType));
        JMethod constructor = jclass.constructor(1);
        constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)nameField), (JExpression)constructor.param(stringClass, nameField.name())).assign((JAssignmentTarget)JExpr._this().ref((JVar)valueField), (JExpression)constructor.param((JType)propertyType, valueField.name()));
        return jclass;
    }

    private JDefinedClass generateDeserializer(JDefinedClass relatedClass, JType propertyType) throws JClassAlreadyExistsException {
        JDefinedClass definedClass = GeneratorUtils.deserializerClass(relatedClass);
        GeneratorUtils.fillDeserializer(definedClass, relatedClass, (method, parserParam) -> method.body()._return((JExpression)definedClass.owner().ref("io.serverlessworkflow.serialization.DeserializeHelper").staticInvoke("deserializeItem").arg((JExpression)parserParam).arg(relatedClass.dotclass()).arg(((JClass)propertyType).dotclass())));
        return definedClass;
    }

    private JDefinedClass generateSerializer(JDefinedClass relatedClass, JMethod nameMethod, JMethod valueMethod) throws JClassAlreadyExistsException {
        JDefinedClass definedClass = GeneratorUtils.serializerClass(relatedClass);
        GeneratorUtils.fillSerializer(definedClass, relatedClass, (method, valueParam, genParam) -> {
            JBlock body = method.body();
            body.invoke((JExpression)genParam, "writeStartObject");
            body.invoke((JExpression)genParam, "writeObjectField").arg((JExpression)valueParam.invoke(nameMethod)).arg((JExpression)valueParam.invoke(valueMethod));
            body.invoke((JExpression)genParam, "writeEndObject");
        });
        return definedClass;
    }

    private boolean checkIntValue(JsonNode node, String propName, int value) {
        return node.has(propName) && node.get(propName).asInt() == value;
    }
}

