/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.Buffer;
import java.io.InputStream;
import java.util.Objects;

final class BufferInputStream
extends InputStream {
    private final Buffer buffer;

    BufferInputStream(Buffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    @Override
    public int read() {
        if (this.buffer.readableBytes() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int readableBytes = this.buffer.readableBytes();
        if (readableBytes == 0) {
            return -1;
        }
        int bytes = Math.min(readableBytes, len);
        this.buffer.readBytes(b, off, bytes);
        return bytes;
    }

    @Override
    public long skip(long n) {
        int skipped = Math.min(this.buffer.readableBytes(), (int)Math.min(Integer.MAX_VALUE, n));
        this.buffer.skipBytes(skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.buffer.readableBytes();
    }
}

