/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.Buffer;
import java.io.InputStream;
import java.util.Objects;

final class BufferInputStream
extends InputStream {
    private final Buffer buffer;
    private int mark;

    BufferInputStream(Buffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
        this.mark = buffer.readerIndex();
    }

    @Override
    public int read() {
        if (this.buffer.readableBytes() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int readableBytes = this.buffer.readableBytes();
        if (readableBytes == 0) {
            return -1;
        }
        int bytes = Math.min(readableBytes, len);
        this.buffer.readBytes(b, off, bytes);
        return bytes;
    }

    @Override
    public long skip(long n) {
        int skipped = (int)Math.min((long)this.buffer.readableBytes(), n);
        if (skipped <= 0) {
            return 0L;
        }
        this.buffer.skipBytes(skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.buffer.readableBytes();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.buffer.readerIndex();
    }

    @Override
    public void reset() {
        this.buffer.readerIndex(this.mark);
    }
}

