/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.transport.api.RetryableException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public abstract class AbstractRetryingFilterBuilder<Builder extends AbstractRetryingFilterBuilder<Builder, Filter, Meta>, Filter, Meta> {
    private static final Duration FULL_JITTER = Duration.ofDays(1024L);
    private int maxRetries;
    @Nullable
    private BiPredicate<Meta, Throwable> retryForPredicate;

    private Builder castThis() {
        return (Builder)this;
    }

    public final Builder maxRetries(int maxRetries) {
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
        }
        this.maxRetries = maxRetries;
        return this.castThis();
    }

    public final Builder retryFor(BiPredicate<Meta, Throwable> retryForPredicate) {
        this.retryForPredicate = Objects.requireNonNull(retryForPredicate);
        return this.castThis();
    }

    public final Filter buildWithImmediateRetries() {
        return this.build(this.readOnlySettings(null, null, null, null, false));
    }

    public final Filter buildWithConstantBackoff(Duration delay) {
        return this.build(this.readOnlySettings(delay, null, null, null, false));
    }

    public final Filter buildWithConstantBackoff(Duration delay, Executor timerExecutor) {
        return this.build(this.readOnlySettings(delay, null, null, timerExecutor, false));
    }

    public final Filter buildWithConstantBackoffFullJitter(Duration delay) {
        return this.build(this.readOnlySettings(delay, FULL_JITTER, null, null, false));
    }

    public final Filter buildWithConstantBackoffFullJitter(Duration delay, Executor timerExecutor) {
        return this.build(this.readOnlySettings(delay, FULL_JITTER, null, timerExecutor, false));
    }

    public final Filter buildWithConstantBackoffDeltaJitter(Duration delay, Duration jitter) {
        return this.build(this.readOnlySettings(delay, jitter, null, null, false));
    }

    public final Filter buildWithConstantBackoffDeltaJitter(Duration delay, Duration jitter, Executor timerExecutor) {
        return this.build(this.readOnlySettings(delay, jitter, null, timerExecutor, false));
    }

    public final Filter buildWithExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay) {
        return this.build(this.readOnlySettings(initialDelay, FULL_JITTER, maxDelay, null, true));
    }

    public final Filter buildWithExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        return this.build(this.readOnlySettings(initialDelay, FULL_JITTER, maxDelay, timerExecutor, true));
    }

    public final Filter buildWithExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay) {
        return this.build(this.readOnlySettings(initialDelay, jitter, maxDelay, null, true));
    }

    public final Filter buildWithExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        return this.build(this.readOnlySettings(initialDelay, jitter, maxDelay, timerExecutor, true));
    }

    protected abstract Filter build(ReadOnlyRetryableSettings<Meta> var1);

    public BiPredicate<Meta, Throwable> defaultRetryForPredicate() {
        return (meta, throwable) -> throwable instanceof RetryableException;
    }

    private ReadOnlyRetryableSettings<Meta> readOnlySettings(@Nullable Duration initialDelay, @Nullable Duration jitter, @Nullable Duration maxDelay, @Nullable Executor timerExecutor, boolean exponential) {
        return new ReadOnlyRetryableSettings(this.maxRetries > 0 ? this.maxRetries : (exponential ? 2 : 1), this.retryForPredicate != null ? this.retryForPredicate : this.defaultRetryForPredicate(), initialDelay, jitter, maxDelay, timerExecutor, exponential);
    }

    public static final class ReadOnlyRetryableSettings<Meta> {
        private final int maxRetries;
        private final BiPredicate<Meta, Throwable> retryForPredicate;
        @Nullable
        private final Duration initialDelay;
        @Nullable
        private final Duration jitter;
        @Nullable
        private final Duration maxDelay;
        @Nullable
        private final Executor timerExecutor;
        private final boolean exponential;

        private ReadOnlyRetryableSettings(int maxRetries, BiPredicate<Meta, Throwable> retryForPredicate, @Nullable Duration initialDelay, @Nullable Duration jitter, @Nullable Duration maxDelay, @Nullable Executor timerExecutor, boolean exponential) {
            this.maxRetries = maxRetries;
            this.retryForPredicate = retryForPredicate;
            this.initialDelay = initialDelay;
            this.timerExecutor = timerExecutor;
            this.exponential = exponential;
            this.jitter = jitter;
            this.maxDelay = maxDelay;
        }

        public boolean isRetryable(Meta meta, Throwable throwable) {
            return this.retryForPredicate.test(meta, throwable);
        }

        public BiIntFunction<Throwable, Completable> newStrategy(Executor alternativeTimerExecutor) {
            Executor effectiveExecutor;
            if (this.initialDelay == null) {
                return (count, throwable) -> count <= this.maxRetries ? Completable.completed() : Completable.failed((Throwable)throwable);
            }
            assert (this.jitter != null);
            Executor executor = effectiveExecutor = this.timerExecutor == null ? Objects.requireNonNull(alternativeTimerExecutor) : this.timerExecutor;
            if (this.exponential) {
                assert (this.maxDelay != null);
                return this.jitter == FULL_JITTER ? RetryStrategies.retryWithExponentialBackoffFullJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.maxDelay, (Executor)effectiveExecutor) : RetryStrategies.retryWithExponentialBackoffDeltaJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.jitter, (Duration)this.maxDelay, (Executor)effectiveExecutor);
            }
            return this.jitter == FULL_JITTER ? RetryStrategies.retryWithConstantBackoffFullJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Executor)effectiveExecutor) : RetryStrategies.retryWithConstantBackoffDeltaJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.jitter, (Executor)effectiveExecutor);
        }
    }
}

