/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.servicetalk.data.jackson.JacksonSerializer;
import io.servicetalk.data.jackson.JacksonStreamingSerializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class JacksonSerializerFactory {
    public static final JacksonSerializerFactory JACKSON = new JacksonSerializerFactory();
    private final ObjectMapper mapper;
    private final Map<Object, StreamingSerializerDeserializer> streamingSerializerMap;
    private final Map<Object, SerializerDeserializer> serializerMap;

    private JacksonSerializerFactory() {
        this(new ObjectMapper());
    }

    public JacksonSerializerFactory(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
        this.streamingSerializerMap = new ConcurrentHashMap<Object, StreamingSerializerDeserializer>();
        this.serializerMap = new ConcurrentHashMap<Object, SerializerDeserializer>();
    }

    public <T> SerializerDeserializer<T> serializerDeserializer(Class<T> clazz) {
        return this.serializerMap.computeIfAbsent(clazz, clazz2 -> new JacksonSerializer(this.mapper, (Class)clazz2));
    }

    public <T> SerializerDeserializer<T> serializerDeserializer(TypeReference<T> typeRef) {
        return this.serializerMap.computeIfAbsent(typeRef, typeRef2 -> new JacksonSerializer(this.mapper, (TypeReference)typeRef2));
    }

    public <T> SerializerDeserializer<T> serializerDeserializer(JavaType type) {
        return this.serializerMap.computeIfAbsent(type, type2 -> new JacksonSerializer(this.mapper, (JavaType)type2));
    }

    public <T> StreamingSerializerDeserializer<T> streamingSerializerDeserializer(Class<T> clazz) {
        return this.streamingSerializerMap.computeIfAbsent(clazz, clazz2 -> new JacksonStreamingSerializer(this.mapper, (Class)clazz2));
    }

    public <T> StreamingSerializerDeserializer<T> streamingSerializerDeserializer(TypeReference<T> typeRef) {
        return this.streamingSerializerMap.computeIfAbsent(typeRef, typeRef2 -> new JacksonStreamingSerializer(this.mapper, (TypeReference)typeRef2));
    }

    public <T> StreamingSerializerDeserializer<T> streamingSerializerDeserializer(JavaType type) {
        return this.streamingSerializerMap.computeIfAbsent(type, type2 -> new JacksonStreamingSerializer(this.mapper, (JavaType)type2));
    }
}

