/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.protobuf.jersey;

import com.google.protobuf.MessageLite;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.data.protobuf.ProtobufSerializerFactory;
import io.servicetalk.data.protobuf.jersey.ProtobufMediaTypes;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.http.router.jersey.internal.SourceWrappers;
import io.servicetalk.serializer.api.Deserializer;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ExecutionContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.ResourceMethod;

@Priority(value=4100)
@Consumes(value={"application/x-protobuf", "application/x-protobuf-var-int"})
@Produces(value={"application/x-protobuf", "application/x-protobuf-var-int"})
final class ProtobufSerializerMessageBodyReaderWriter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    @Context
    private Provider<Ref<ConnectionContext>> ctxRefProvider;
    @Context
    private Provider<ContainerRequestContext> requestCtxProvider;
    @Context
    private Providers providers;
    @Context
    private HttpHeaders headers;

    ProtobufSerializerMessageBodyReaderWriter() {
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ProtobufSerializerMessageBodyReaderWriter.isSupportedMediaType(type, mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        ProtobufSerializerFactory serializerFactory = this.getSerializerFactory(mediaType);
        ExecutionContext executionContext = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext();
        BufferAllocator allocator = executionContext.bufferAllocator();
        int contentLength = ((ContainerRequestContext)this.requestCtxProvider.get()).getLength();
        if (Single.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> ProtobufSerializerMessageBodyReaderWriter.deserialize((Publisher<Buffer>)p, serializerFactory.serializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType)), contentLength, a), (is, a) -> new SourceWrappers.SingleSource(ProtobufSerializerMessageBodyReaderWriter.deserialize(ProtobufSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializerFactory.serializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType)), contentLength, a)));
        }
        if (Publisher.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> serializerFactory.streamingSerializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType)).deserialize(p, a), (is, a) -> new SourceWrappers.PublisherSource(serializerFactory.streamingSerializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType)).deserialize(ProtobufSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), a)));
        }
        return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> (MessageLite)ProtobufSerializerMessageBodyReaderWriter.deserializeObject((Publisher<Buffer>)p, serializerFactory.serializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.castClass(type)), contentLength, a), (is, a) -> (MessageLite)ProtobufSerializerMessageBodyReaderWriter.deserializeObject(ProtobufSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializerFactory.serializerDeserializer(ProtobufSerializerMessageBodyReaderWriter.castClass(type)), contentLength, a));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !ProtobufSerializerMessageBodyReaderWriter.isSse((ContainerRequestContext)this.requestCtxProvider.get()) && ProtobufSerializerMessageBodyReaderWriter.isSupportedMediaType(ProtobufSerializerMessageBodyReaderWriter.getRawWriteType(genericType), mediaType);
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        Publisher bufferPublisher;
        BufferAllocator allocator = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext().bufferAllocator();
        if (o instanceof Single) {
            Class clazz = genericType instanceof Class ? (Class)genericType : ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType);
            SerializerDeserializer serializer = this.getSerializerFactory(mediaType).serializerDeserializer(clazz);
            bufferPublisher = ((Single)o).map(arg_0 -> ProtobufSerializerMessageBodyReaderWriter.lambda$writeTo$6((Serializer)serializer, allocator, arg_0)).toPublisher();
        } else if (o instanceof Publisher) {
            Class clazz = genericType instanceof Class ? (Class)genericType : ProtobufSerializerMessageBodyReaderWriter.getSourceClass(genericType);
            StreamingSerializerDeserializer serializer = this.getSerializerFactory(mediaType).streamingSerializerDeserializer(clazz);
            bufferPublisher = serializer.serialize((Publisher)o, allocator);
        } else {
            SerializerDeserializer serializer = this.getSerializerFactory(mediaType).serializerDeserializer(o.getClass());
            bufferPublisher = Publisher.from((Object)serializer.serialize(o, allocator));
        }
        RequestProperties.setResponseBufferPublisher((Publisher)bufferPublisher, (ContainerRequestContext)((ContainerRequestContext)this.requestCtxProvider.get()));
    }

    private ProtobufSerializerFactory getSerializerFactory(MediaType mediaType) {
        ContextResolver contextResolver = this.providers.getContextResolver(ProtobufSerializerFactory.class, mediaType);
        return contextResolver != null ? (ProtobufSerializerFactory)contextResolver.getContext(ProtobufSerializerFactory.class) : ProtobufSerializerFactory.PROTOBUF;
    }

    private static Publisher<Buffer> toBufferPublisher(InputStream is, BufferAllocator a) {
        return Publisher.fromInputStream((InputStream)is, (arg_0, arg_1, arg_2) -> ((BufferAllocator)a).wrap(arg_0, arg_1, arg_2));
    }

    private static <T> Single<T> deserialize(Publisher<Buffer> bufferPublisher, Deserializer<T> deserializer, int contentLength, BufferAllocator allocator) {
        return bufferPublisher.collect(() -> ProtobufSerializerMessageBodyReaderWriter.newBufferForRequestContent(contentLength, allocator), Buffer::writeBytes).map(buf -> {
            try {
                return deserializer.deserialize(buf, allocator);
            }
            catch (NoSuchElementException e) {
                throw new BadRequestException("No deserializable Protobuf content", (Throwable)e);
            }
            catch (SerializationException e) {
                throw new BadRequestException("Invalid Protobuf data", (Throwable)e);
            }
        });
    }

    static Buffer newBufferForRequestContent(int contentLength, BufferAllocator allocator) {
        return contentLength == -1 ? allocator.newBuffer() : allocator.newBuffer(contentLength);
    }

    static <T> T deserializeObject(Publisher<Buffer> bufferPublisher, Deserializer<T> deserializer, int contentLength, BufferAllocator allocator) {
        return (T)FutureUtils.awaitResult((Future)ProtobufSerializerMessageBodyReaderWriter.deserialize(bufferPublisher, deserializer, contentLength, allocator).toFuture());
    }

    private static boolean isSse(ContainerRequestContext requestCtx) {
        ResourceMethod method = ((ExtendedUriInfo)requestCtx.getUriInfo()).getMatchedResourceMethod();
        return method != null && method.isSse();
    }

    private static boolean isSupportedMediaType(Class<?> type, MediaType mediaType) {
        return !Publisher.class.equals(type) && mediaType.getType().equalsIgnoreCase(ProtobufMediaTypes.APPLICATION_X_PROTOBUF_TYPE.getType()) && (mediaType.getSubtype().equalsIgnoreCase(ProtobufMediaTypes.APPLICATION_X_PROTOBUF_TYPE.getSubtype()) || mediaType.getSubtype().toLowerCase(Locale.ENGLISH).endsWith('+' + ProtobufMediaTypes.APPLICATION_X_PROTOBUF_TYPE.getSubtype())) || Publisher.class.equals(type) && mediaType.getType().equalsIgnoreCase(ProtobufMediaTypes.APPLICATION_X_PROTOBUF_VAR_INT_TYPE.getType()) && mediaType.getSubtype().equalsIgnoreCase(ProtobufMediaTypes.APPLICATION_X_PROTOBUF_VAR_INT_TYPE.getSubtype());
    }

    private static <T> Class<T> castClass(Class<Object> sourceClass) {
        return sourceClass;
    }

    private static <T> Class<T> getSourceClass(Type sourceType) {
        Type sourceContentType = ((ParameterizedType)sourceType).getActualTypeArguments()[0];
        if (sourceContentType instanceof Class) {
            return (Class)sourceContentType;
        }
        if (sourceContentType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)sourceContentType).getRawType();
        }
        throw new IllegalArgumentException("Unsupported source type: " + sourceType);
    }

    private static Class<?> getRawWriteType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return genericType.getClass();
        }
        return (Class)((ParameterizedType)genericType).getRawType();
    }

    private static /* synthetic */ Object lambda$writeTo$6(Serializer serializer, BufferAllocator allocator, Object t) {
        return serializer.serialize(t, allocator);
    }
}

