/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.protobuf.jersey;

import io.servicetalk.data.protobuf.jersey.ProtobufSerializationExceptionMapper;
import io.servicetalk.data.protobuf.jersey.ProtobufSerializerMessageBodyReaderWriter;
import java.util.Map;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceTalkProtobufSerializerFeature
implements Feature {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTalkProtobufSerializerFeature.class);
    static final String ST_PROTOBUF_FEATURE = ServiceTalkProtobufSerializerFeature.class.getSimpleName();
    static final String PROTOBUF_FEATURE = "jersey.config.protobufFeature";

    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String protobufFeature = (String)CommonProperties.getValue((Map)config.getProperties(), (RuntimeType)config.getRuntimeType(), (String)ST_PROTOBUF_FEATURE, (Object)PROTOBUF_FEATURE, String.class);
        if (!PROTOBUF_FEATURE.equalsIgnoreCase(protobufFeature)) {
            LOGGER.warn("Skipping registration of: {} as Protobuf support is already provided by: {}", (Object)ST_PROTOBUF_FEATURE, (Object)protobufFeature);
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime((String)PROTOBUF_FEATURE, (RuntimeType)config.getRuntimeType()), (Object)ST_PROTOBUF_FEATURE);
        if (!config.isRegistered(ProtobufSerializerMessageBodyReaderWriter.class)) {
            context.register(ProtobufSerializationExceptionMapper.class);
            context.register(ProtobufSerializerMessageBodyReaderWriter.class);
        }
        return true;
    }
}

