/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.encoding.api.AbstractContentCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
abstract class AbstractZipContentCodec
extends AbstractContentCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractZipContentCodec.class);
    private static final Buffer END_OF_STREAM = ReadOnlyBufferAllocators.DEFAULT_RO_ALLOCATOR.fromAscii((CharSequence)" ");
    private static final int FOOTER_LEN = 10;
    protected final int chunkSize;
    private final int maxPayloadSize;

    AbstractZipContentCodec(CharSequence name, int chunkSize, int maxPayloadSize) {
        super(name);
        this.chunkSize = chunkSize;
        this.maxPayloadSize = maxPayloadSize;
    }

    abstract boolean supportsChecksum();

    abstract Inflater newRawInflater();

    abstract DeflaterOutputStream newDeflaterOutputStream(OutputStream var1) throws IOException;

    abstract InflaterInputStream newInflaterInputStream(InputStream var1) throws IOException;

    @Override
    public Buffer encode(Buffer src, BufferAllocator allocator) {
        return this.encode(src, 0, src.readableBytes(), allocator);
    }

    @Override
    public final Buffer encode(Buffer src, int offset, int length, BufferAllocator allocator) {
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset + " (expected >= 0)");
        }
        Buffer dst = allocator.newBuffer(this.chunkSize);
        DeflaterOutputStream output = null;
        try {
            src.readerIndex(src.readerIndex() + offset);
            output = this.newDeflaterOutputStream(Buffer.asOutputStream((Buffer)dst));
            if (src.hasArray()) {
                output.write(src.array(), src.arrayOffset() + src.readerIndex(), length);
                src.readerIndex(src.readerIndex() + length);
            } else {
                while (src.readableBytes() > 0) {
                    byte[] onHeap = new byte[Math.min(src.readableBytes(), Math.min(this.chunkSize, length))];
                    src.readBytes(onHeap);
                    output.write(onHeap);
                }
            }
            output.finish();
            this.close(output);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error while encoding with {}", (Object)this.name(), (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(output);
                throw throwable;
            }
        }
        return dst;
    }

    @Override
    public final Publisher<Buffer> encode(Publisher<Buffer> from, final BufferAllocator allocator) {
        return from.concat(Single.succeeded((Object)END_OF_STREAM)).liftSync(subscriber -> new PublisherSource.Subscriber<Buffer>(){
            private final SwappableBufferOutputStream stream = new SwappableBufferOutputStream();
            @Nullable
            private DeflaterOutputStream output;
            private boolean headerWritten;

            public void onSubscribe(PublisherSource.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            public void onNext(Buffer next) {
                try {
                    Buffer dst = allocator.newBuffer(next == END_OF_STREAM ? 10 : AbstractZipContentCodec.this.chunkSize);
                    this.stream.swap(dst);
                    if (!this.headerWritten) {
                        this.output = AbstractZipContentCodec.this.newDeflaterOutputStream(this.stream);
                    }
                    assert (this.output != null);
                    if (next == END_OF_STREAM) {
                        this.output.finish();
                        subscriber.onNext((Object)dst);
                        return;
                    }
                    this.consume(next);
                    this.headerWritten = true;
                    subscriber.onNext((Object)dst);
                }
                catch (Exception e) {
                    LOGGER.error("Error while encoding with {}", (Object)AbstractZipContentCodec.this.name(), (Object)e);
                    this.onError(e);
                }
            }

            private void consume(Buffer next) throws IOException {
                assert (this.output != null);
                if (next.hasArray()) {
                    this.output.write(next.array(), next.arrayOffset() + next.readerIndex(), next.readableBytes());
                } else {
                    while (next.readableBytes() > 0) {
                        byte[] onHeap = new byte[Math.min(next.readableBytes(), AbstractZipContentCodec.this.chunkSize)];
                        next.readBytes(onHeap);
                        this.output.write(onHeap);
                    }
                }
                this.output.flush();
            }

            public void onError(Throwable t) {
                AbstractZipContentCodec.this.close(this.output);
                subscriber.onError(t);
            }

            public void onComplete() {
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (IOException e) {
                    this.onError(e);
                    return;
                }
                subscriber.onComplete();
            }
        });
    }

    @Override
    public Buffer decode(Buffer src, BufferAllocator allocator) {
        return this.decode(src, 0, src.readableBytes(), allocator);
    }

    @Override
    public final Buffer decode(Buffer src, int offset, int length, BufferAllocator allocator) {
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset + " (expected >= 0)");
        }
        src.readerIndex(src.readerIndex() + offset);
        Buffer dst = allocator.newBuffer(this.chunkSize, this.maxPayloadSize);
        InflaterInputStream input = null;
        try {
            input = this.newInflaterInputStream(new BufferBoundedInputStream(src, length));
            int read = dst.setBytesUntilEndStream(0, (InputStream)input, this.chunkSize);
            dst.writerIndex(read);
            this.close(input);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error while decoding with {}", (Object)this.name(), (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(input);
                throw throwable;
            }
        }
        return dst;
    }

    @Override
    public final Publisher<Buffer> decode(Publisher<Buffer> from, final BufferAllocator allocator) {
        return from.liftSync(subscriber -> new PublisherSource.Subscriber<Buffer>(){
            @Nullable
            Inflater inflater;
            @Nullable
            ZLibStreamDecoder streamDecoder;
            @Nullable
            PublisherSource.Subscription subscription;

            public void onSubscribe(PublisherSource.Subscription subscription) {
                try {
                    this.inflater = AbstractZipContentCodec.this.newRawInflater();
                    this.streamDecoder = new ZLibStreamDecoder(this.inflater, AbstractZipContentCodec.this.supportsChecksum(), AbstractZipContentCodec.this.maxPayloadSize);
                    this.subscription = subscription;
                }
                catch (Exception e) {
                    if (this.inflater != null) {
                        this.inflater.end();
                    }
                    LOGGER.error("Error while decoding with {}", (Object)AbstractZipContentCodec.this.name(), (Object)e);
                    SubscriberUtils.deliverErrorFromSource((PublisherSource.Subscriber)subscriber, (Throwable)e);
                    return;
                }
                subscriber.onSubscribe(subscription);
            }

            public void onNext(@Nullable Buffer src) {
                assert (this.streamDecoder != null);
                assert (this.subscription != null);
                assert (src != null);
                try {
                    if (this.streamDecoder.isFinished()) {
                        throw new IllegalStateException("Stream encoder previously closed but more input arrived ");
                    }
                    Buffer part = allocator.newBuffer(AbstractZipContentCodec.this.chunkSize);
                    this.streamDecoder.decode(src, part);
                    if (part.readableBytes() > 0) {
                        subscriber.onNext((Object)part);
                    }
                    this.subscription.request(1L);
                }
                catch (Exception e) {
                    LOGGER.error("Error while decoding with {}", (Object)AbstractZipContentCodec.this.name(), (Object)e);
                    this.onError(e);
                }
            }

            public void onError(Throwable t) {
                assert (this.inflater != null);
                this.inflater.end();
                subscriber.onError(t);
            }

            public void onComplete() {
                assert (this.inflater != null);
                this.inflater.end();
                subscriber.onComplete();
            }
        });
    }

    private void close(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected IO exception while closing buffer streams", (Throwable)e);
        }
    }

    private static final class BufferBoundedInputStream
    extends InputStream {
        private final Buffer buffer;
        private int count;

        BufferBoundedInputStream(Buffer buffer, int limit) {
            this.buffer = Objects.requireNonNull(buffer);
            this.count = limit;
        }

        @Override
        public int read() {
            if (this.buffer.readableBytes() == 0 || --this.count <= 0) {
                return -1;
            }
            return this.buffer.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int bytes = Math.min(this.buffer.readableBytes(), Math.min(this.count, len));
            if (bytes <= 0) {
                return -1;
            }
            this.count -= bytes;
            this.buffer.readBytes(b, off, bytes);
            return bytes;
        }

        @Override
        public long skip(long n) {
            int skipped = (int)Math.min((long)this.buffer.readableBytes(), n);
            if (skipped <= 0) {
                return 0L;
            }
            this.count -= skipped;
            this.buffer.skipBytes(skipped);
            return skipped;
        }

        @Override
        public int available() {
            return this.buffer.readableBytes();
        }
    }

    private static class SwappableBufferOutputStream
    extends OutputStream {
        @Nullable
        private Buffer buffer;

        private SwappableBufferOutputStream() {
        }

        private void swap(Buffer buffer) {
            this.buffer = Objects.requireNonNull(buffer);
        }

        @Override
        public void write(int b) {
            assert (this.buffer != null);
            this.buffer.writeInt(b);
        }

        @Override
        public void write(byte[] b) {
            assert (this.buffer != null);
            this.buffer.writeBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            assert (this.buffer != null);
            this.buffer.writeBytes(b, off, len);
        }
    }

    static class ZLibStreamDecoder {
        private static final int FHCRC = 2;
        private static final int FEXTRA = 4;
        private static final int FNAME = 8;
        private static final int FCOMMENT = 16;
        private static final int FRESERVED = 224;
        @Nullable
        private final CRC32 crc;
        private final Inflater inflater;
        private final int maxPayloadSize;
        private State state = State.HEADER_START;
        private int flags = -1;
        private int xlen = -1;
        private int payloadSizeAcc;
        private boolean finished;

        ZLibStreamDecoder(Inflater inflater, boolean supportsChksum, int maxPayloadSize) {
            this.inflater = inflater;
            this.maxPayloadSize = maxPayloadSize;
            this.crc = supportsChksum ? new CRC32() : null;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Nullable
        protected void decode(Buffer in, Buffer out) throws Exception {
            if (this.finished) {
                in.skipBytes(in.readableBytes());
                return;
            }
            int readableBytes = in.readableBytes();
            if (readableBytes == 0) {
                return;
            }
            if (this.crc != null) {
                switch (this.state) {
                    case FOOTER_START: {
                        if (this.readGZIPFooter(in)) {
                            this.finished = true;
                        }
                        return;
                    }
                }
                if (this.state != State.HEADER_END && !this.readGZIPHeader(in)) {
                    return;
                }
                readableBytes = in.readableBytes();
            }
            if (in.hasArray()) {
                this.inflater.setInput(in.array(), in.arrayOffset() + in.readerIndex(), readableBytes);
            } else {
                byte[] array = new byte[readableBytes];
                in.getBytes(in.readerIndex(), array);
                this.inflater.setInput(array);
            }
            try {
                boolean readFooter = false;
                while (!this.inflater.needsInput()) {
                    byte[] outArray = out.array();
                    int writerIndex = out.writerIndex();
                    int outIndex = out.arrayOffset() + writerIndex;
                    int outputLength = this.inflater.inflate(outArray, outIndex, out.writableBytes());
                    this.payloadSizeAcc += outputLength;
                    if (this.payloadSizeAcc > this.maxPayloadSize) {
                        throw new IllegalStateException("Max decompressed payload limit has been reached: " + this.payloadSizeAcc + " (expected <= " + this.maxPayloadSize + ") bytes");
                    }
                    if (outputLength > 0) {
                        out.writerIndex(writerIndex + outputLength);
                        if (this.crc != null) {
                            this.crc.update(outArray, outIndex, outputLength);
                        }
                    } else if (this.inflater.needsDictionary()) {
                        throw new IOException("decompression failure, unable to set dictionary as non was specified");
                    }
                    if (this.inflater.finished()) {
                        if (this.crc == null) {
                            this.finished = true;
                            break;
                        }
                        readFooter = true;
                        break;
                    }
                    out.ensureWritable(this.inflater.getRemaining() << 1);
                }
                in.skipBytes(readableBytes - this.inflater.getRemaining());
                if (readFooter) {
                    this.state = State.FOOTER_START;
                    if (this.readGZIPFooter(in)) {
                        this.finished = true;
                        this.inflater.end();
                    }
                }
            }
            catch (DataFormatException e) {
                throw new IOException("decompression failure", e);
            }
        }

        private boolean readGZIPHeader(Buffer in) throws IOException {
            switch (this.state) {
                case HEADER_START: {
                    if (in.readableBytes() < 10) {
                        return false;
                    }
                    byte magic0 = in.readByte();
                    byte magic1 = in.readByte();
                    if (magic0 != 31) {
                        throw new IOException("Input is not in the GZIP format");
                    }
                    this.crc.update(magic0);
                    this.crc.update(magic1);
                    short method = in.readUnsignedByte();
                    if (method != 8) {
                        throw new IOException("Unsupported compression method " + method + " in the GZIP header");
                    }
                    this.crc.update(method);
                    this.flags = in.readUnsignedByte();
                    this.crc.update(this.flags);
                    if ((this.flags & 0xE0) != 0) {
                        throw new IOException("Reserved flags are set in the GZIP header");
                    }
                    this.crc.update(in.readUnsignedByte());
                    this.crc.update(in.readUnsignedByte());
                    this.crc.update(in.readUnsignedByte());
                    this.crc.update(in.readUnsignedByte());
                    this.crc.update(in.readUnsignedByte());
                    this.crc.update(in.readUnsignedByte());
                    this.state = State.FLG_READ;
                }
                case FLG_READ: {
                    if ((this.flags & 4) != 0) {
                        if (in.readableBytes() < 2) {
                            return false;
                        }
                        short xlen1 = in.readUnsignedByte();
                        short xlen2 = in.readUnsignedByte();
                        this.crc.update(xlen1);
                        this.crc.update(xlen2);
                        this.xlen |= xlen1 << 8 | xlen2;
                    }
                    this.state = State.XLEN_READ;
                }
                case XLEN_READ: {
                    if (this.xlen != -1) {
                        if (in.readableBytes() < this.xlen) {
                            return false;
                        }
                        for (int i = 0; i < this.xlen; ++i) {
                            this.crc.update(in.readUnsignedByte());
                        }
                    }
                    this.state = State.SKIP_FNAME;
                }
                case SKIP_FNAME: {
                    short b;
                    if ((this.flags & 8) != 0) {
                        if (in.readableBytes() > 0) {
                            return false;
                        }
                        do {
                            b = in.readUnsignedByte();
                            this.crc.update(b);
                        } while (b != 0 && in.readableBytes() > 0);
                    }
                    this.state = State.SKIP_COMMENT;
                }
                case SKIP_COMMENT: {
                    short b;
                    if ((this.flags & 0x10) != 0) {
                        if (in.readableBytes() > 0) {
                            return false;
                        }
                        do {
                            b = in.readUnsignedByte();
                            this.crc.update(b);
                        } while (b != 0 && in.readableBytes() > 0);
                    }
                    this.state = State.PROCESS_FHCRC;
                }
                case PROCESS_FHCRC: {
                    if ((this.flags & 2) != 0) {
                        if (in.readableBytes() < 4) {
                            return false;
                        }
                        this.verifyCrc(in);
                    }
                    this.crc.reset();
                    this.state = State.HEADER_END;
                }
                case HEADER_END: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }

        private boolean readGZIPFooter(Buffer buf) throws IOException {
            if (buf.readableBytes() < 8) {
                return false;
            }
            this.verifyCrc(buf);
            int dataLength = 0;
            for (int i = 0; i < 4; ++i) {
                dataLength |= buf.readUnsignedByte() << i * 8;
            }
            int readLength = this.inflater.getTotalOut();
            if (dataLength != readLength) {
                throw new IOException("Number of bytes mismatch. Expected: " + dataLength + ", Got: " + readLength);
            }
            return true;
        }

        private void verifyCrc(Buffer in) throws IOException {
            long crcValue = 0L;
            for (int i = 0; i < 4; ++i) {
                crcValue |= (long)in.readUnsignedByte() << i * 8;
            }
            long readCrc = this.crc.getValue();
            if (crcValue != readCrc) {
                throw new IOException("CRC value mismatch. Expected: " + crcValue + ", Got: " + readCrc);
            }
        }

        private static enum State {
            HEADER_START,
            HEADER_END,
            FLG_READ,
            XLEN_READ,
            SKIP_FNAME,
            SKIP_COMMENT,
            PROCESS_FHCRC,
            FOOTER_START;

        }
    }
}

