/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.BlockingGrpcClient;
import io.servicetalk.grpc.api.FilterableGrpcClient;
import io.servicetalk.grpc.api.GrpcClient;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientFactory;
import io.servicetalk.grpc.api.GrpcClientFilterFactory;
import io.servicetalk.grpc.api.GrpcClientSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.grpc.api.SingleAddressGrpcClientBuilder;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.IoExecutor;
import java.net.SocketOption;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class GrpcClientBuilder<U, R>
implements SingleAddressGrpcClientBuilder<U, R, ServiceDiscovererEvent<R>> {
    private boolean appendedCatchAllFilter;

    @Override
    public abstract GrpcClientBuilder<U, R> ioExecutor(IoExecutor var1);

    @Override
    public abstract GrpcClientBuilder<U, R> bufferAllocator(BufferAllocator var1);

    @Override
    public abstract GrpcClientBuilder<U, R> executionStrategy(GrpcExecutionStrategy var1);

    @Override
    public abstract <T> GrpcClientBuilder<U, R> socketOption(SocketOption<T> var1, T var2);

    @Override
    @Deprecated
    public abstract GrpcClientBuilder<U, R> enableWireLogging(String var1);

    @Override
    public abstract GrpcClientBuilder<U, R> enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    @Override
    public abstract GrpcClientBuilder<U, R> protocols(HttpProtocolConfig ... var1);

    public abstract GrpcClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> var1);

    @Override
    public abstract GrpcClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory var1);

    @Override
    public abstract GrpcClientBuilder<U, R> appendConnectionFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpConnectionFilterFactory var2);

    @Override
    @Deprecated
    public abstract GrpcClientSecurityConfigurator<U, R> secure();

    public abstract GrpcClientBuilder<U, R> sslConfig(ClientSslConfig var1);

    public abstract GrpcClientBuilder<U, R> autoRetryStrategy(AutoRetryStrategyProvider var1);

    public abstract GrpcClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> var1);

    public abstract GrpcClientBuilder<U, R> disableHostHeaderFallback();

    public abstract GrpcClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> var1);

    public abstract GrpcClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> var1);

    public final GrpcClientBuilder<U, R> appendHttpClientFilter(StreamingHttpClientFilterFactory factory) {
        this.appendCatchAllFilterIfRequired();
        this.doAppendHttpClientFilter(factory);
        return this;
    }

    public final GrpcClientBuilder<U, R> appendHttpClientFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpClientFilterFactory factory) {
        this.appendCatchAllFilterIfRequired();
        this.doAppendHttpClientFilter(predicate, factory);
        return this;
    }

    public final <Client extends GrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> Client build(GrpcClientFactory<Client, ?, Filter, FilterableClient, FilterFactory> clientFactory) {
        return clientFactory.newClientForCallFactory(this.newGrpcClientCallFactory());
    }

    public final <BlockingClient extends BlockingGrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> BlockingClient buildBlocking(GrpcClientFactory<?, BlockingClient, Filter, FilterableClient, FilterFactory> clientFactory) {
        return clientFactory.newBlockingClientForCallFactory(this.newGrpcClientCallFactory());
    }

    public final MultiClientBuilder buildMulti() {
        final GrpcClientCallFactory callFactory = this.newGrpcClientCallFactory();
        return new MultiClientBuilder(){

            @Override
            public <Client extends GrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> Client build(GrpcClientFactory<Client, ?, Filter, FilterableClient, FilterFactory> clientFactory) {
                return clientFactory.newClient(callFactory);
            }

            @Override
            public <BlockingClient extends BlockingGrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> BlockingClient buildBlocking(GrpcClientFactory<?, BlockingClient, Filter, FilterableClient, FilterFactory> clientFactory) {
                return clientFactory.newBlockingClient(callFactory);
            }
        };
    }

    protected abstract GrpcClientCallFactory newGrpcClientCallFactory();

    protected abstract void doAppendHttpClientFilter(StreamingHttpClientFilterFactory var1);

    protected abstract void doAppendHttpClientFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpClientFilterFactory var2);

    private void appendCatchAllFilterIfRequired() {
        if (!this.appendedCatchAllFilter) {
            this.doAppendHttpClientFilter(client -> new StreamingHttpClientFilter(client){

                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                    Single resp;
                    try {
                        resp = super.request(delegate, strategy, request);
                    }
                    catch (Throwable t2) {
                        return Single.failed((Throwable)GrpcClientBuilder.toGrpcException(t2));
                    }
                    return resp.recoverWith(t -> Single.failed((Throwable)GrpcClientBuilder.toGrpcException(t)));
                }
            });
            this.appendedCatchAllFilter = true;
        }
    }

    private static GrpcStatusException toGrpcException(Throwable cause) {
        return GrpcStatus.fromThrowable(cause).asException();
    }

    public static interface MultiClientBuilder {
        public <Client extends GrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> Client build(GrpcClientFactory<Client, ?, Filter, FilterableClient, FilterFactory> var1);

        public <BlockingClient extends BlockingGrpcClient<?>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> BlockingClient buildBlocking(GrpcClientFactory<?, BlockingClient, Filter, FilterableClient, FilterFactory> var1);
    }
}

