/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.grpc.api.DefaultGrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategies;

public final class GrpcExecutionStrategies {
    private static final DefaultGrpcExecutionStrategy NO_OFFLOADS = new DefaultGrpcExecutionStrategy(HttpExecutionStrategies.noOffloadsStrategy());

    private GrpcExecutionStrategies() {
    }

    public static GrpcExecutionStrategy defaultStrategy() {
        return Builder.DEFAULT;
    }

    public static GrpcExecutionStrategy defaultStrategy(Executor executor) {
        return new DefaultGrpcExecutionStrategy(HttpExecutionStrategies.defaultStrategy((Executor)executor));
    }

    public static GrpcExecutionStrategy noOffloadsStrategy() {
        return NO_OFFLOADS;
    }

    public static Builder customStrategyBuilder() {
        return new Builder();
    }

    public static final class Builder {
        static final GrpcExecutionStrategy DEFAULT = new DefaultGrpcExecutionStrategy(HttpExecutionStrategies.defaultStrategy());
        private final HttpExecutionStrategies.Builder httpBuilder = HttpExecutionStrategies.customStrategyBuilder();

        public Builder offloadReceiveMetadata() {
            this.httpBuilder.offloadReceiveMetadata();
            return this;
        }

        public Builder offloadReceiveData() {
            this.httpBuilder.offloadReceiveData();
            return this;
        }

        public Builder offloadSend() {
            this.httpBuilder.offloadSend();
            return this;
        }

        public Builder offloadAll() {
            this.httpBuilder.offloadAll();
            return this;
        }

        public Builder offloadNone() {
            this.httpBuilder.offloadNone();
            return this;
        }

        public Builder executor(Executor executor) {
            this.httpBuilder.executor(executor);
            return this;
        }

        public Builder offloadWithThreadAffinity() {
            this.httpBuilder.offloadWithThreadAffinity();
            return this;
        }

        public GrpcExecutionStrategy build() {
            return new DefaultGrpcExecutionStrategy(this.httpBuilder.build());
        }
    }
}

