/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.ConnectablePayloadWriter;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.grpc.api.GrpcPayloadWriter;
import io.servicetalk.grpc.api.GrpcRoutes;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.oio.api.PayloadWriter;
import io.servicetalk.oio.api.internal.PayloadWriterUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.io.IOException;
import java.util.Objects;

final class GrpcRouteConversions {
    private GrpcRouteConversions() {
    }

    static <Req, Resp> GrpcRoutes.Route<Req, Resp> toRoute(final GrpcRoutes.StreamingRoute<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.Route<Req, Resp>(){

            @Override
            public Single<Resp> handle(GrpcServiceContext ctx, Req request) {
                return original.handle(ctx, Publisher.from(request)).firstOrError();
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.Route<Req, Resp> toRoute(GrpcRoutes.BlockingStreamingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toRoute(GrpcRouteConversions.toStreaming(original));
    }

    static <Req, Resp> GrpcRoutes.Route<Req, Resp> toRoute(GrpcRoutes.BlockingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toRoute(GrpcRouteConversions.toStreaming(original));
    }

    static <Req, Resp> GrpcRoutes.StreamingRoute<Req, Resp> toStreaming(final GrpcRoutes.Route<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.StreamingRoute<Req, Resp>(){

            @Override
            public Publisher<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                return request.firstOrError().flatMapPublisher(req -> original.handle(ctx, req).toPublisher());
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.StreamingRoute<Req, Resp> toStreaming(final GrpcRoutes.BlockingStreamingRoute<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.StreamingRoute<Req, Resp>(){
            private final AsyncCloseable closeable;
            {
                this.closeable = GrpcRouteConversions.toAsyncCloseable(original);
            }

            @Override
            public Publisher<Resp> handle(final GrpcServiceContext ctx, final Publisher<Req> request) {
                return new Publisher<Resp>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void handleSubscribe(PublisherSource.Subscriber<? super Resp> subscriber) {
                        final ConnectablePayloadWriter connectablePayloadWriter = new ConnectablePayloadWriter();
                        Publisher pub = connectablePayloadWriter.connect();
                        CompletableSource.Processor exceptionProcessor = Processors.newCompletableProcessor();
                        SourceAdapters.toSource((Publisher)SourceAdapters.fromSource((CompletableSource)exceptionProcessor).merge(pub)).subscribe(subscriber);
                        GrpcPayloadWriter grpcPayloadWriter = new GrpcPayloadWriter<Resp>(){

                            public void write(Resp resp) throws IOException {
                                connectablePayloadWriter.write(resp);
                            }

                            public void close() throws IOException {
                                connectablePayloadWriter.close();
                            }

                            public void close(Throwable cause) throws IOException {
                                connectablePayloadWriter.close(cause);
                            }

                            public void flush() throws IOException {
                                connectablePayloadWriter.flush();
                            }
                        };
                        try {
                            original.handle(ctx, request.toIterable(), grpcPayloadWriter);
                            exceptionProcessor.onComplete();
                        }
                        catch (Throwable t) {
                            try {
                                exceptionProcessor.onError(t);
                            }
                            finally {
                                PayloadWriterUtils.safeClose((PayloadWriter)grpcPayloadWriter, (Throwable)t);
                            }
                        }
                    }
                };
            }

            @Override
            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.StreamingRoute<Req, Resp> toStreaming(final GrpcRoutes.BlockingRoute<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.StreamingRoute<Req, Resp>(){
            private final AsyncCloseable closeable;
            {
                this.closeable = GrpcRouteConversions.toAsyncCloseable(original);
            }

            @Override
            public Publisher<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                return request.firstOrError().map(req -> {
                    try {
                        return original.handle(ctx, req);
                    }
                    catch (Exception e) {
                        return PlatformDependent.throwException((Throwable)e);
                    }
                }).toPublisher();
            }

            @Override
            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.RequestStreamingRoute<Req, Resp> toRequestStreamingRoute(final GrpcRoutes.Route<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.RequestStreamingRoute<Req, Resp>(){

            @Override
            public Single<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                return request.firstOrError().flatMap(req -> original.handle(ctx, req));
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.RequestStreamingRoute<Req, Resp> toRequestStreamingRoute(final GrpcRoutes.StreamingRoute<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.RequestStreamingRoute<Req, Resp>(){

            @Override
            public Single<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                return original.handle(ctx, request).firstOrError();
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.RequestStreamingRoute<Req, Resp> toRequestStreamingRoute(GrpcRoutes.BlockingStreamingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toRequestStreamingRoute(GrpcRouteConversions.toStreaming(original));
    }

    static <Req, Resp> GrpcRoutes.RequestStreamingRoute<Req, Resp> toRequestStreamingRoute(GrpcRoutes.BlockingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toRequestStreamingRoute(GrpcRouteConversions.toStreaming(original));
    }

    static <Req, Resp> GrpcRoutes.ResponseStreamingRoute<Req, Resp> toResponseStreamingRoute(final GrpcRoutes.Route<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.ResponseStreamingRoute<Req, Resp>(){

            @Override
            public Publisher<Resp> handle(GrpcServiceContext ctx, Req request) {
                return original.handle(ctx, request).toPublisher();
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.ResponseStreamingRoute<Req, Resp> toResponseStreamingRoute(final GrpcRoutes.StreamingRoute<Req, Resp> original) {
        Objects.requireNonNull(original);
        return new GrpcRoutes.ResponseStreamingRoute<Req, Resp>(){

            @Override
            public Publisher<Resp> handle(GrpcServiceContext ctx, Req request) {
                return original.handle(ctx, Publisher.from(request));
            }

            @Override
            public Completable closeAsync() {
                return original.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return original.closeAsyncGracefully();
            }
        };
    }

    static <Req, Resp> GrpcRoutes.ResponseStreamingRoute<Req, Resp> toResponseStreamingRoute(GrpcRoutes.BlockingStreamingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toResponseStreamingRoute(GrpcRouteConversions.toStreaming(original));
    }

    static <Req, Resp> GrpcRoutes.ResponseStreamingRoute<Req, Resp> toResponseStreamingRoute(GrpcRoutes.BlockingRoute<Req, Resp> original) {
        return GrpcRouteConversions.toResponseStreamingRoute(GrpcRouteConversions.toStreaming(original));
    }

    static AsyncCloseable toAsyncCloseable(final GracefulAutoCloseable original) {
        return AsyncCloseables.toAsyncCloseable(graceful -> new Completable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                try {
                    subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)cause);
                    return;
                }
                try {
                    if (graceful) {
                        original.closeGracefully();
                    } else {
                        original.close();
                    }
                }
                catch (Throwable t) {
                    subscriber.onError(t);
                    return;
                }
                subscriber.onComplete();
            }
        });
    }
}

