/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import com.google.rpc.Status;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcStatusException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class GrpcStatus {
    static final Map<Integer, GrpcStatus> CACHED_INSTANCES;
    private final GrpcStatusCode code;
    @Nullable
    private final Throwable cause;
    @Nullable
    private final String description;

    public GrpcStatus(GrpcStatusCode code) {
        this(code, null);
    }

    public GrpcStatus(GrpcStatusCode code, @Nullable Throwable cause) {
        this(code, cause, null);
    }

    public GrpcStatus(GrpcStatusCode code, @Nullable Throwable cause, @Nullable CharSequence description) {
        this.code = Objects.requireNonNull(code);
        this.cause = cause;
        this.description = description == null ? null : description.toString();
    }

    public static GrpcStatus fromCodeValue(String codeValue) {
        try {
            return GrpcStatus.fromCodeValue(Integer.parseInt(codeValue));
        }
        catch (NumberFormatException e) {
            return GrpcStatusCode.UNKNOWN.status();
        }
    }

    public static GrpcStatus fromCodeValue(int codeValue) {
        GrpcStatus status = CACHED_INSTANCES.get(codeValue);
        return status != null ? status : GrpcStatusCode.UNKNOWN.status();
    }

    public static GrpcStatus fromThrowable(Throwable t) {
        GrpcStatus status = GrpcStatus.fromThrowableNullable(t);
        return status == null ? new GrpcStatus(GrpcStatusCode.UNKNOWN, t) : status;
    }

    @Nullable
    public static GrpcStatus fromThrowableNullable(Throwable t) {
        GrpcStatusException exception = GrpcStatus.unwrapGrpcStatusException(t);
        return exception == null ? null : exception.status();
    }

    public GrpcStatusException asException() {
        return new GrpcStatusException(this, () -> null);
    }

    public GrpcStatusException asException(Supplier<Status> applicationStatusSupplier) {
        return new GrpcStatusException(this, applicationStatusSupplier);
    }

    public GrpcStatusCode code() {
        return this.code;
    }

    @Nullable
    public Throwable cause() {
        return this.cause;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    static GrpcStatusException unwrapGrpcStatusException(Throwable error) {
        for (Throwable cause = error; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof GrpcStatusException)) continue;
            return (GrpcStatusException)cause;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcStatus that = (GrpcStatus)o;
        if (this.code != that.code) {
            return false;
        }
        if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GrpcStatus{code=" + (Object)((Object)this.code) + ", cause=" + this.cause + ", description='" + this.description + '\'' + '}';
    }

    static {
        HashMap<Integer, GrpcStatus> cachedInstances = new HashMap<Integer, GrpcStatus>(GrpcStatusCode.values().length, 1.0f);
        for (GrpcStatusCode code : GrpcStatusCode.values()) {
            GrpcStatus replaced = cachedInstances.put(code.value(), new GrpcStatus(code));
            if (replaced == null) continue;
            throw new IllegalStateException(String.format("GrpcStatusCode value %d used by both %s and %s", new Object[]{code.value(), replaced.code, code}));
        }
        CACHED_INSTANCES = Collections.unmodifiableMap(cachedInstances);
    }
}

