/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.grpc.api.GrpcStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum GrpcStatusCode {
    OK(0),
    CANCELLED(1),
    UNKNOWN(2),
    INVALID_ARGUMENT(3),
    DEADLINE_EXCEEDED(4),
    NOT_FOUND(5),
    ALREADY_EXISTS(6),
    PERMISSION_DENIED(7),
    RESOURCE_EXHAUSTED(8),
    FAILED_PRECONDITION(9),
    ABORTED(10),
    OUT_OF_RANGE(11),
    UNIMPLEMENTED(12),
    INTERNAL(13),
    UNAVAILABLE(14),
    DATA_LOSS(15),
    UNAUTHENTICATED(16);

    private static final Map<Integer, GrpcStatusCode> INT_TO_STATUS_CODE_MAP;
    private final int value;

    private GrpcStatusCode(int value) {
        this.value = value;
    }

    public static GrpcStatusCode fromCodeValue(CharSequence codeValue) {
        try {
            return GrpcStatusCode.fromCodeValue(Integer.parseInt(codeValue.toString()));
        }
        catch (NumberFormatException e) {
            return UNKNOWN;
        }
    }

    public static GrpcStatusCode fromCodeValue(int codeValue) {
        return INT_TO_STATUS_CODE_MAP.getOrDefault(codeValue, UNKNOWN);
    }

    public int value() {
        return this.value;
    }

    public GrpcStatus status() {
        return GrpcStatus.CACHED_INSTANCES.get(this.value);
    }

    static {
        HashMap<Integer, GrpcStatusCode> intToStatusCodeMap = new HashMap<Integer, GrpcStatusCode>(GrpcStatusCode.values().length);
        for (GrpcStatusCode code : GrpcStatusCode.values()) {
            GrpcStatusCode replaced = intToStatusCodeMap.put(code.value(), code);
            if (replaced == null) continue;
            throw new IllegalStateException(String.format("GrpcStatusCode value %d used by both %s and %s", new Object[]{code.value(), replaced, code}));
        }
        INT_TO_STATUS_CODE_MAP = Collections.unmodifiableMap(intToStatusCodeMap);
    }
}

