/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.encoding.api.internal.HeaderUtils;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.grpc.api.MessageEncodingException;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.StatelessTrailersTransformer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class GrpcUtils {
    private static final CharSequence GRPC_CONTENT_TYPE = CharSequences.newAsciiString((String)"application/grpc");
    private static final CharSequence GRPC_STATUS_CODE_TRAILER = CharSequences.newAsciiString((String)"grpc-status");
    private static final CharSequence GRPC_STATUS_DETAILS_TRAILER = CharSequences.newAsciiString((String)"grpc-status-details-bin");
    private static final CharSequence GRPC_STATUS_MESSAGE_TRAILER = CharSequences.newAsciiString((String)"grpc-message");
    private static final CharSequence GRPC_USER_AGENT = CharSequences.newAsciiString((String)"grpc-service-talk/");
    private static final CharSequence GRPC_MESSAGE_ENCODING_KEY = CharSequences.newAsciiString((String)"grpc-encoding");
    private static final CharSequence GRPC_ACCEPT_ENCODING_KEY = CharSequences.newAsciiString((String)"grpc-accept-encoding");
    private static final GrpcStatus STATUS_OK = GrpcStatus.fromCodeValue(GrpcStatusCode.OK.value());
    private static final List<ContentCodec> GRPC_ACCEPT_ENCODING_NONE = Collections.singletonList(Identity.identity());
    private static final ConcurrentMap<List<ContentCodec>, CharSequence> ENCODINGS_HEADER_CACHE = new ConcurrentHashMap<List<ContentCodec>, CharSequence>();
    private static final TrailersTransformer<Object, Buffer> ENSURE_GRPC_STATUS_RECEIVED = new StatelessTrailersTransformer<Buffer>(){

        protected HttpHeaders payloadComplete(HttpHeaders trailers) {
            GrpcUtils.ensureGrpcStatusReceived(trailers);
            return trailers;
        }
    };

    private GrpcUtils() {
    }

    static void initRequest(HttpRequestMetaData request, List<ContentCodec> supportedEncodings) {
        assert (HttpRequestMethod.POST.equals((Object)request.method()));
        HttpHeaders headers = request.headers();
        headers.set(HttpHeaderNames.USER_AGENT, GRPC_USER_AGENT);
        headers.set(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
        headers.set(HttpHeaderNames.CONTENT_TYPE, GRPC_CONTENT_TYPE);
        headers.set(GRPC_ACCEPT_ENCODING_KEY, GrpcUtils.acceptedEncodingsHeaderValueOrCached(supportedEncodings));
    }

    static <T> StreamingHttpResponse newResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, Publisher<T> payload, HttpSerializer<T> serializer, BufferAllocator allocator) {
        return GrpcUtils.newStreamingResponse(responseFactory, context).payloadBody(payload, serializer).transform((TrailersTransformer)new GrpcStatusUpdater(allocator, STATUS_OK));
    }

    static StreamingHttpResponse newResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, GrpcStatus status, BufferAllocator allocator) {
        return GrpcUtils.newStreamingResponse(responseFactory, context).transform((TrailersTransformer)new GrpcStatusUpdater(allocator, status));
    }

    static HttpResponse newResponse(HttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, BufferAllocator allocator) {
        HttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        GrpcUtils.setStatusOk(response.trailers(), allocator);
        return response;
    }

    static HttpResponse newErrorResponse(HttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, Throwable cause, BufferAllocator allocator) {
        HttpResponse response = GrpcUtils.newResponse(responseFactory, context, allocator);
        GrpcUtils.setStatus(response.trailers(), cause, allocator);
        return response;
    }

    static StreamingHttpResponse newErrorResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, Throwable cause, BufferAllocator allocator) {
        return GrpcUtils.newStreamingResponse(responseFactory, context).transform((TrailersTransformer)new ErrorUpdater(cause, allocator));
    }

    private static StreamingHttpResponse newStreamingResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context) {
        StreamingHttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        return response;
    }

    static void setStatusOk(HttpHeaders trailers, BufferAllocator allocator) {
        GrpcUtils.setStatus(trailers, STATUS_OK, null, allocator);
    }

    static void setStatus(HttpHeaders trailers, GrpcStatus status, @Nullable Status details, BufferAllocator allocator) {
        trailers.set(GRPC_STATUS_CODE_TRAILER, (CharSequence)String.valueOf(status.code().value()));
        if (status.description() != null) {
            trailers.set(GRPC_STATUS_MESSAGE_TRAILER, (CharSequence)status.description());
        }
        if (details != null) {
            trailers.set(GRPC_STATUS_DETAILS_TRAILER, CharSequences.newAsciiString((Buffer)allocator.wrap(Base64.getEncoder().encode(details.toByteArray()))));
        }
    }

    static void setStatus(HttpHeaders trailers, Throwable cause, BufferAllocator allocator) {
        if (cause instanceof GrpcStatusException) {
            GrpcStatusException grpcStatusException = (GrpcStatusException)cause;
            GrpcUtils.setStatus(trailers, grpcStatusException.status(), grpcStatusException.applicationStatus(), allocator);
        } else if (cause instanceof MessageEncodingException) {
            MessageEncodingException msgEncException = (MessageEncodingException)cause;
            GrpcStatus status = new GrpcStatus(GrpcStatusCode.UNIMPLEMENTED, cause, "Message encoding '" + msgEncException.encoding() + "' not supported ");
            GrpcUtils.setStatus(trailers, status, null, allocator);
        } else {
            GrpcUtils.setStatus(trailers, GrpcStatus.fromCodeValue(GrpcStatusCode.UNKNOWN.value()), null, allocator);
        }
    }

    static <Resp> Publisher<Resp> validateResponseAndGetPayload(StreamingHttpResponse response, HttpDeserializer<Resp> deserializer) {
        HttpHeaders headers = response.headers();
        GrpcUtils.ensureGrpcContentType(response.status(), headers);
        GrpcStatusCode grpcStatusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(headers);
        if (grpcStatusCode != null) {
            GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(grpcStatusCode, headers);
            return response.messageBody().ignoreElements().concat(grpcStatusException != null ? Publisher.failed((Throwable)grpcStatusException) : Publisher.empty());
        }
        response.transform(ENSURE_GRPC_STATUS_RECEIVED);
        return deserializer.deserialize(headers, response.payloadBody());
    }

    static <Resp> Resp validateResponseAndGetPayload(HttpResponse response, HttpDeserializer<Resp> deserializer) {
        HttpHeaders headers = response.headers();
        HttpHeaders trailers = response.trailers();
        GrpcUtils.ensureGrpcContentType(response.status(), headers);
        GrpcStatusCode grpcStatusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(trailers);
        if (grpcStatusCode != null) {
            GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(grpcStatusCode, trailers);
            if (grpcStatusException != null) {
                throw grpcStatusException;
            }
            return (Resp)response.payloadBody(deserializer);
        }
        GrpcUtils.ensureGrpcStatusReceived(headers);
        return (Resp)response.payloadBody(deserializer);
    }

    private static void ensureGrpcContentType(HttpResponseStatus status, HttpHeaders headers) {
        CharSequence contentTypeHeader = headers.get(HttpHeaderNames.CONTENT_TYPE);
        if (!io.servicetalk.http.api.HeaderUtils.hasContentType((HttpHeaders)headers, (CharSequence)GRPC_CONTENT_TYPE, null)) {
            throw new GrpcStatus(GrpcStatusCode.INTERNAL, null, "HTTP status code: " + status + "\n\tinvalid " + HttpHeaderNames.CONTENT_TYPE + ": " + contentTypeHeader + "\n\theaders: " + headers.toString()).asException();
        }
    }

    private static void ensureGrpcStatusReceived(HttpHeaders headers) {
        GrpcStatusCode statusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(headers);
        if (statusCode == null) {
            throw new GrpcStatus(GrpcStatusCode.UNKNOWN, null, "Response does not contain " + GRPC_STATUS_CODE_TRAILER + " header or trailer").asException();
        }
        GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(statusCode, headers);
        if (grpcStatusException != null) {
            throw grpcStatusException;
        }
    }

    static ContentCodec readGrpcMessageEncoding(HttpMetaData httpMetaData, List<ContentCodec> allowedEncodings) {
        CharSequence encoding = httpMetaData.headers().get(GRPC_MESSAGE_ENCODING_KEY);
        if (encoding == null) {
            return Identity.identity();
        }
        ContentCodec enc = HeaderUtils.encodingFor(allowedEncodings, (CharSequence)encoding);
        if (enc == null) {
            throw new MessageEncodingException(encoding.toString());
        }
        return enc;
    }

    static ContentCodec negotiateAcceptedEncoding(HttpMetaData httpMetaData, List<ContentCodec> allowedCodings) {
        CharSequence acceptEncHeaderValue = httpMetaData.headers().get(GRPC_ACCEPT_ENCODING_KEY);
        ContentCodec encoding = HeaderUtils.negotiateAcceptedEncoding((CharSequence)acceptEncHeaderValue, allowedCodings);
        return encoding == null ? Identity.identity() : encoding;
    }

    private static void initResponse(HttpResponseMetaData response, @Nullable GrpcServiceContext context) {
        HttpHeaders headers = response.headers();
        headers.set(HttpHeaderNames.SERVER, GRPC_USER_AGENT);
        headers.set(HttpHeaderNames.CONTENT_TYPE, GRPC_CONTENT_TYPE);
        if (context != null) {
            headers.set(GRPC_ACCEPT_ENCODING_KEY, GrpcUtils.acceptedEncodingsHeaderValueOrCached(context.supportedMessageCodings()));
        }
    }

    @Nullable
    private static GrpcStatusCode extractGrpcStatusCodeFromHeaders(HttpHeaders headers) {
        CharSequence statusCode = headers.get(GRPC_STATUS_CODE_TRAILER);
        if (statusCode == null) {
            return null;
        }
        return GrpcStatusCode.fromCodeValue(statusCode);
    }

    @Nullable
    private static GrpcStatusException convertToGrpcStatusException(GrpcStatusCode grpcStatusCode, HttpHeaders headers) {
        if (grpcStatusCode.value() == GrpcStatusCode.OK.value()) {
            return null;
        }
        GrpcStatus grpcStatus = new GrpcStatus(grpcStatusCode, null, headers.get(GRPC_STATUS_MESSAGE_TRAILER));
        return grpcStatus.asException(new StatusSupplier(headers, grpcStatus));
    }

    @Nullable
    private static Status getStatusDetails(HttpHeaders headers) {
        CharSequence details = headers.get(GRPC_STATUS_DETAILS_TRAILER);
        if (details == null) {
            return null;
        }
        try {
            return (Status)Status.parser().parseFrom(Base64.getDecoder().decode(details.toString()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Could not decode grpc status details", e);
        }
    }

    private static CharSequence acceptedEncodingsHeaderValueOrCached(List<ContentCodec> codings) {
        return ENCODINGS_HEADER_CACHE.computeIfAbsent(codings, __ -> GrpcUtils.acceptedEncodingsHeaderValue0(codings));
    }

    private static CharSequence acceptedEncodingsHeaderValue0(List<ContentCodec> codings) {
        StringBuilder builder = new StringBuilder();
        for (ContentCodec codec : codings) {
            if (codec == Identity.identity()) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(codec.name());
        }
        return CharSequences.newAsciiString((String)builder.toString());
    }

    static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    private static final class ErrorUpdater
    extends StatelessTrailersTransformer<Buffer> {
        private final Throwable cause;
        private final BufferAllocator allocator;

        ErrorUpdater(Throwable cause, BufferAllocator allocator) {
            this.cause = cause;
            this.allocator = allocator;
        }

        protected HttpHeaders payloadComplete(HttpHeaders trailers) {
            GrpcUtils.setStatus(trailers, this.cause, this.allocator);
            return trailers;
        }
    }

    static final class GrpcStatusUpdater
    extends StatelessTrailersTransformer<Buffer> {
        private final BufferAllocator allocator;
        private final GrpcStatus successStatus;

        GrpcStatusUpdater(BufferAllocator allocator, GrpcStatus successStatus) {
            this.allocator = allocator;
            this.successStatus = successStatus;
        }

        protected HttpHeaders payloadComplete(HttpHeaders trailers) {
            GrpcUtils.setStatus(trailers, this.successStatus, null, this.allocator);
            return trailers;
        }

        protected HttpHeaders payloadFailed(Throwable cause, HttpHeaders trailers) {
            GrpcUtils.setStatus(trailers, cause, this.allocator);
            return trailers;
        }
    }

    private static final class StatusSupplier
    implements Supplier<Status> {
        private final HttpHeaders headers;
        private final GrpcStatus fallbackStatus;
        @Nullable
        private volatile StatusHolder statusHolder;

        StatusSupplier(HttpHeaders headers, GrpcStatus fallbackStatus) {
            this.headers = headers;
            this.fallbackStatus = fallbackStatus;
        }

        @Override
        @Nullable
        public Status get() {
            StatusHolder statusHolder = this.statusHolder;
            if (statusHolder == null) {
                Status statusFromHeaders = GrpcUtils.getStatusDetails(this.headers);
                if (statusFromHeaders == null) {
                    Status.Builder builder = Status.newBuilder().setCode(this.fallbackStatus.code().value());
                    if (this.fallbackStatus.description() != null) {
                        builder.setMessage(this.fallbackStatus.description());
                    }
                    this.statusHolder = statusHolder = new StatusHolder(builder.build());
                } else {
                    this.statusHolder = statusHolder = new StatusHolder(statusFromHeaders);
                }
            }
            return statusHolder.status;
        }

        private static final class StatusHolder {
            @Nullable
            final Status status;

            StatusHolder(@Nullable Status status) {
                this.status = status;
            }
        }
    }
}

