/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.BlockingIterables;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.grpc.api.DefaultGrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.grpc.api.GrpcUtils;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestFactory;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultGrpcClientCallFactory
implements GrpcClientCallFactory {
    private final StreamingHttpClient streamingHttpClient;
    private final GrpcExecutionContext executionContext;
    @Nullable
    private final Duration defaultTimeout;

    DefaultGrpcClientCallFactory(StreamingHttpClient streamingHttpClient, @Nullable Duration defaultTimeout) {
        this.streamingHttpClient = Objects.requireNonNull(streamingHttpClient);
        this.executionContext = new DefaultGrpcExecutionContext(streamingHttpClient.executionContext());
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.ClientCall<Req, Resp> newCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        Objects.requireNonNull(serializationProvider);
        Objects.requireNonNull(requestClass);
        Objects.requireNonNull(responseClass);
        HttpClient client = this.streamingHttpClient.asClient();
        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
        return (metadata, request) -> {
            Duration timeout = this.timeoutForRequest(metadata.timeout());
            HttpRequest httpRequest = this.newAggregatedRequest(metadata, request, (HttpRequestFactory)client, serializationProvider, supportedCodings, timeout, requestClass);
            GrpcExecutionStrategy strategy = metadata.strategy();
            return (strategy == null ? client.request(httpRequest) : client.request((HttpExecutionStrategy)strategy, httpRequest)).map(response -> GrpcUtils.validateResponseAndGetPayload(response, serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)response, supportedCodings), responseClass))).onErrorMap(GrpcUtils::toGrpcException);
        };
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.StreamingClientCall<Req, Resp> newStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        Objects.requireNonNull(serializationProvider);
        Objects.requireNonNull(requestClass);
        Objects.requireNonNull(responseClass);
        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
        return (metadata, request) -> {
            StreamingHttpRequest httpRequest = this.streamingHttpClient.post(metadata.path());
            Duration timeout = this.timeoutForRequest(metadata.timeout());
            GrpcUtils.initRequest((HttpRequestMetaData)httpRequest, supportedCodings, timeout);
            httpRequest.payloadBody(request.map(GrpcUtils::uncheckedCast), serializationProvider.serializerFor(metadata.requestEncoding(), requestClass));
            GrpcExecutionStrategy strategy = metadata.strategy();
            return (strategy == null ? this.streamingHttpClient.request(httpRequest) : this.streamingHttpClient.request((HttpExecutionStrategy)strategy, httpRequest)).flatMapPublisher(response -> GrpcUtils.validateResponseAndGetPayload(response, serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)response, supportedCodings), responseClass))).onErrorMap(GrpcUtils::toGrpcException);
        };
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.RequestStreamingClientCall<Req, Resp> newRequestStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        GrpcClientCallFactory.StreamingClientCall streamingClientCall = this.newStreamingCall(serializationProvider, requestClass, responseClass);
        return (metadata, request) -> streamingClientCall.request(metadata, request).firstOrError();
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.ResponseStreamingClientCall<Req, Resp> newResponseStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        GrpcClientCallFactory.StreamingClientCall streamingClientCall = this.newStreamingCall(serializationProvider, requestClass, responseClass);
        return (metadata, request) -> streamingClientCall.request(metadata, Publisher.from((Object)request));
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.BlockingClientCall<Req, Resp> newBlockingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        Objects.requireNonNull(serializationProvider);
        Objects.requireNonNull(requestClass);
        Objects.requireNonNull(responseClass);
        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
        BlockingHttpClient client = this.streamingHttpClient.asBlockingClient();
        return (metadata, request) -> {
            Duration timeout = this.timeoutForRequest(metadata.timeout());
            HttpRequest httpRequest = this.newAggregatedRequest(metadata, request, (HttpRequestFactory)client, serializationProvider, supportedCodings, timeout, requestClass);
            GrpcExecutionStrategy strategy = metadata.strategy();
            try {
                HttpResponse response = strategy == null ? client.request(httpRequest) : client.request((HttpExecutionStrategy)strategy, httpRequest);
                return GrpcUtils.validateResponseAndGetPayload(response, serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)response, supportedCodings), responseClass));
            }
            catch (Exception all) {
                throw GrpcUtils.toGrpcException(all);
            }
        };
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.BlockingStreamingClientCall<Req, Resp> newBlockingStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        Objects.requireNonNull(serializationProvider);
        Objects.requireNonNull(requestClass);
        Objects.requireNonNull(responseClass);
        BlockingStreamingHttpClient client = this.streamingHttpClient.asBlockingStreamingClient();
        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
        return (metadata, request) -> {
            BlockingStreamingHttpRequest httpRequest = client.post(metadata.path());
            Duration timeout = this.timeoutForRequest(metadata.timeout());
            GrpcUtils.initRequest((HttpRequestMetaData)httpRequest, supportedCodings, timeout);
            httpRequest.payloadBody(request, serializationProvider.serializerFor(metadata.requestEncoding(), requestClass));
            GrpcExecutionStrategy strategy = metadata.strategy();
            try {
                BlockingStreamingHttpResponse response = strategy == null ? client.request(httpRequest) : client.request((HttpExecutionStrategy)strategy, httpRequest);
                return GrpcUtils.validateResponseAndGetPayload(response.toStreamingResponse(), serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)response, supportedCodings), responseClass)).onErrorMap(GrpcUtils::toGrpcException).toIterable();
            }
            catch (Exception all) {
                throw GrpcUtils.toGrpcException(all);
            }
        };
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.BlockingRequestStreamingClientCall<Req, Resp> newBlockingRequestStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        GrpcClientCallFactory.BlockingStreamingClientCall streamingClientCall = this.newBlockingStreamingCall(serializationProvider, requestClass, responseClass);
        return (metadata, request) -> {
            try (BlockingIterator iterator = streamingClientCall.request(metadata, request).iterator();){
                Object firstItem = iterator.next();
                assert (firstItem != null);
                if (iterator.hasNext()) {
                    iterator.next();
                    throw new IllegalArgumentException("More than one response message received");
                }
                Object object = firstItem;
                return object;
            }
        };
    }

    @Override
    public <Req, Resp> GrpcClientCallFactory.BlockingResponseStreamingClientCall<Req, Resp> newBlockingResponseStreamingCall(GrpcSerializationProvider serializationProvider, Class<Req> requestClass, Class<Resp> responseClass) {
        GrpcClientCallFactory.BlockingStreamingClientCall streamingClientCall = this.newBlockingStreamingCall(serializationProvider, requestClass, responseClass);
        return (metadata, request) -> streamingClientCall.request(metadata, (Iterable)BlockingIterables.singletonBlockingIterable((Object)request));
    }

    @Override
    public GrpcExecutionContext executionContext() {
        return this.executionContext;
    }

    public Completable closeAsync() {
        return this.streamingHttpClient.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.streamingHttpClient.closeAsyncGracefully();
    }

    public Completable onClose() {
        return this.streamingHttpClient.onClose();
    }

    private <Req> HttpRequest newAggregatedRequest(GrpcClientMetadata metadata, Req rawReq, HttpRequestFactory requestFactory, GrpcSerializationProvider serializationProvider, List<ContentCodec> supportedCodings, Duration timeout, Class<Req> requestClass) {
        HttpRequest httpRequest = requestFactory.post(metadata.path());
        GrpcUtils.initRequest((HttpRequestMetaData)httpRequest, supportedCodings, timeout);
        return httpRequest.payloadBody(GrpcUtils.uncheckedCast(rawReq), serializationProvider.serializerFor(metadata.requestEncoding(), requestClass));
    }

    @Nullable
    private Duration timeoutForRequest(@Nullable Duration metaDataTimeout) {
        Duration contextTimeout;
        Long deadline = (Long)AsyncContext.get((ContextMap.Key)DeadlineUtils.GRPC_DEADLINE_CONTEXT_KEY);
        Duration duration = contextTimeout = null != deadline ? Duration.ofNanos(deadline - System.nanoTime()) : null;
        Duration timeout = null != contextTimeout ? (null == metaDataTimeout || contextTimeout.compareTo(metaDataTimeout) <= 0 ? contextTimeout : metaDataTimeout) : metaDataTimeout;
        return null != timeout ? timeout : this.defaultTimeout;
    }
}

