/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.grpc.api.DefaultGrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.IoExecutor;
import java.util.Objects;

final class DefaultGrpcExecutionContext
implements GrpcExecutionContext {
    private final ExecutionContext delegate;
    private final GrpcExecutionStrategy strategy;

    DefaultGrpcExecutionContext(HttpExecutionContext httpExecutionContext) {
        this.delegate = (ExecutionContext)Objects.requireNonNull(httpExecutionContext);
        HttpExecutionStrategy httpExecutionStrategy = httpExecutionContext.executionStrategy();
        this.strategy = httpExecutionStrategy instanceof GrpcExecutionStrategy ? (GrpcExecutionStrategy)httpExecutionStrategy : new DefaultGrpcExecutionStrategy(httpExecutionStrategy);
    }

    public BufferAllocator bufferAllocator() {
        return this.delegate.bufferAllocator();
    }

    public IoExecutor ioExecutor() {
        return this.delegate.ioExecutor();
    }

    public Executor executor() {
        return this.delegate.executor();
    }

    @Override
    public GrpcExecutionStrategy executionStrategy() {
        return this.strategy;
    }
}

