/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcUtils;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcExceptionMapperServiceFilter
implements StreamingHttpServiceFilterFactory,
HttpExecutionStrategyInfluencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcExceptionMapperServiceFilter.class);
    public static final StreamingHttpServiceFilterFactory INSTANCE = new GrpcExceptionMapperServiceFilter();

    private GrpcExceptionMapperServiceFilter() {
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                Single handle;
                try {
                    handle = this.delegate().handle(ctx, request, responseFactory);
                }
                catch (Throwable cause2) {
                    return Single.succeeded((Object)GrpcExceptionMapperServiceFilter.convertToGrpcErrorResponse("handle(...)", ctx, request, responseFactory, cause2));
                }
                return handle.onErrorReturn(cause -> GrpcExceptionMapperServiceFilter.convertToGrpcErrorResponse("response", ctx, request, responseFactory, cause));
            }
        };
    }

    private static StreamingHttpResponse convertToGrpcErrorResponse(String what, HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory, Throwable cause) {
        StreamingHttpResponse response = GrpcUtils.newErrorResponse(responseFactory, null, null, cause, ctx.executionContext().bufferAllocator());
        CharSequence codeValue = response.headers().get(GrpcUtils.GRPC_STATUS_CODE_TRAILER);
        assert (codeValue != null);
        LOGGER.error("Unexpected exception during a {} processing for connection={}, request='{} {} {}' was mapped to grpc-status: {} ({})", new Object[]{what, ctx, request.method(), request.requestTarget(), request.version(), codeValue, GrpcStatusCode.fromCodeValue(codeValue), cause});
        return response;
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }
}

