/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.grpc.api.DefaultGrpcServiceContext;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcPayloadWriter;
import io.servicetalk.grpc.api.GrpcRouteConversions;
import io.servicetalk.grpc.api.GrpcRoutes;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcUtils;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpServerResponse;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ServerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrpcRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcRouter.class);
    private final Map<String, RouteProvider> routes;
    private final Map<String, RouteProvider> streamingRoutes;
    private final Map<String, RouteProvider> blockingRoutes;
    private final Map<String, RouteProvider> blockingStreamingRoutes;
    private static final GrpcStatus STATUS_UNIMPLEMENTED = GrpcStatus.fromCodeValue(GrpcStatusCode.UNIMPLEMENTED.value());
    private static final StreamingHttpService NOT_FOUND_SERVICE = (ctx, request, responseFactory) -> {
        StreamingHttpResponse response = GrpcUtils.newErrorResponse(responseFactory, null, STATUS_UNIMPLEMENTED, null, ctx.executionContext().bufferAllocator());
        response.version(request.version());
        return Single.succeeded((Object)response);
    };

    private GrpcRouter(Map<String, RouteProvider> routes, Map<String, RouteProvider> streamingRoutes, Map<String, RouteProvider> blockingRoutes, Map<String, RouteProvider> blockingStreamingRoutes) {
        this.routes = Collections.unmodifiableMap(routes);
        this.streamingRoutes = Collections.unmodifiableMap(streamingRoutes);
        this.blockingRoutes = Collections.unmodifiableMap(blockingRoutes);
        this.blockingStreamingRoutes = Collections.unmodifiableMap(blockingStreamingRoutes);
    }

    Single<ServerContext> bind(GrpcServiceFactory.ServerBinder binder, ExecutionContext executionContext) {
        final CompositeCloseable closeable = AsyncCloseables.newCompositeCloseable();
        final HashMap<String, StreamingHttpService> allRoutes = new HashMap<String, StreamingHttpService>();
        GrpcRouter.populateRoutes(executionContext, allRoutes, this.routes, closeable);
        GrpcRouter.populateRoutes(executionContext, allRoutes, this.streamingRoutes, closeable);
        GrpcRouter.populateRoutes(executionContext, allRoutes, this.blockingRoutes, closeable);
        GrpcRouter.populateRoutes(executionContext, allRoutes, this.blockingStreamingRoutes, closeable);
        return binder.bindStreaming(new StreamingHttpService(){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                StreamingHttpService service;
                if (!HttpRequestMethod.POST.equals((Object)request.method()) || (service = (StreamingHttpService)allRoutes.get(request.path())) == null) {
                    return NOT_FOUND_SERVICE.handle(ctx, request, responseFactory);
                }
                return service.handle(ctx, request, responseFactory);
            }

            public Completable closeAsync() {
                return closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return closeable.closeAsyncGracefully();
            }
        });
    }

    private static void populateRoutes(ExecutionContext executionContext, Map<String, StreamingHttpService> allRoutes, Map<String, RouteProvider> routes, CompositeCloseable closeable) {
        for (Map.Entry<String, RouteProvider> entry : routes.entrySet()) {
            String path = entry.getKey();
            HttpApiConversions.ServiceAdapterHolder adapterHolder = entry.getValue().buildRoute(executionContext);
            StreamingHttpService route = (StreamingHttpService)closeable.append((AsyncCloseable)adapterHolder.adaptor());
            GrpcRouter.verifyNoOverrides(allRoutes.put(path, adapterHolder.serviceInvocationStrategy().offloadService(executionContext.executor(), route)), path, Collections.emptyMap());
        }
    }

    private static void verifyNoOverrides(@Nullable Object oldValue, String path, Map<String, ?> alternativeMap) {
        if (oldValue != null || alternativeMap.containsKey(path)) {
            throw new IllegalStateException("Can not override already registered route for path: " + path);
        }
    }

    static final class RouteProvider
    implements AsyncCloseable {
        private final Function<ExecutionContext, HttpApiConversions.ServiceAdapterHolder> routeProvider;
        private final Supplier<GrpcRoutes.StreamingRoute<?, ?>> toStreamingConverter;
        private final Supplier<GrpcRoutes.RequestStreamingRoute<?, ?>> toRequestStreamingRouteConverter;
        private final Supplier<GrpcRoutes.ResponseStreamingRoute<?, ?>> toResponseStreamingRouteConverter;
        private final Supplier<GrpcRoutes.Route<?, ?>> toRouteConverter;
        private final AsyncCloseable closeable;

        RouteProvider(Function<ExecutionContext, HttpApiConversions.ServiceAdapterHolder> routeProvider, Supplier<GrpcRoutes.StreamingRoute<?, ?>> toStreamingConverter, Supplier<GrpcRoutes.RequestStreamingRoute<?, ?>> toRequestStreamingRouteConverter, Supplier<GrpcRoutes.ResponseStreamingRoute<?, ?>> toResponseStreamingRouteConverter, Supplier<GrpcRoutes.Route<?, ?>> toRouteConverter, AsyncCloseable closeable) {
            this.routeProvider = routeProvider;
            this.toStreamingConverter = toStreamingConverter;
            this.toRequestStreamingRouteConverter = toRequestStreamingRouteConverter;
            this.toResponseStreamingRouteConverter = toResponseStreamingRouteConverter;
            this.toRouteConverter = toRouteConverter;
            this.closeable = closeable;
        }

        RouteProvider(Function<ExecutionContext, HttpApiConversions.ServiceAdapterHolder> routeProvider, Supplier<GrpcRoutes.StreamingRoute<?, ?>> toStreamingConverter, Supplier<GrpcRoutes.RequestStreamingRoute<?, ?>> toRequestStreamingRouteConverter, Supplier<GrpcRoutes.ResponseStreamingRoute<?, ?>> toResponseStreamingRouteConverter, Supplier<GrpcRoutes.Route<?, ?>> toRouteConverter, GracefulAutoCloseable closeable) {
            this(routeProvider, toStreamingConverter, toRequestStreamingRouteConverter, toResponseStreamingRouteConverter, toRouteConverter, GrpcRouteConversions.toAsyncCloseable(closeable));
        }

        HttpApiConversions.ServiceAdapterHolder buildRoute(ExecutionContext executionContext) {
            return this.routeProvider.apply(executionContext);
        }

        <Req, Resp> GrpcRoutes.RequestStreamingRoute<Req, Resp> asRequestStreamingRoute() {
            GrpcRoutes.RequestStreamingRoute<?, ?> toReturn = this.toRequestStreamingRouteConverter.get();
            return toReturn;
        }

        <Req, Resp> GrpcRoutes.ResponseStreamingRoute<Req, Resp> asResponseStreamingRoute() {
            GrpcRoutes.ResponseStreamingRoute<?, ?> toReturn = this.toResponseStreamingRouteConverter.get();
            return toReturn;
        }

        <Req, Resp> GrpcRoutes.StreamingRoute<Req, Resp> asStreamingRoute() {
            GrpcRoutes.StreamingRoute<?, ?> toReturn = this.toStreamingConverter.get();
            return toReturn;
        }

        <Req, Resp> GrpcRoutes.Route<Req, Resp> asRoute() {
            GrpcRoutes.Route<?, ?> toReturn = this.toRouteConverter.get();
            return toReturn;
        }

        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }
    }

    static final class RouteProviders
    implements AsyncCloseable {
        private final Map<String, RouteProvider> routes;
        private final CompositeCloseable closeable;

        RouteProviders(Map<String, RouteProvider> routes) {
            this.routes = routes;
            this.closeable = AsyncCloseables.newCompositeCloseable();
            for (RouteProvider provider : routes.values()) {
                this.closeable.append((AsyncCloseable)provider);
            }
        }

        RouteProvider routeProvider(String path) {
            RouteProvider routeProvider = this.routes.get(path);
            if (routeProvider == null) {
                throw new IllegalArgumentException("No routes registered for path: " + path);
            }
            return routeProvider;
        }

        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }
    }

    private static final class DefaultGrpcPayloadWriter<Resp>
    implements GrpcPayloadWriter<Resp> {
        private final HttpPayloadWriter<Resp> payloadWriter;

        DefaultGrpcPayloadWriter(HttpPayloadWriter<Resp> payloadWriter) {
            this.payloadWriter = payloadWriter;
        }

        public void write(Resp resp) throws IOException {
            this.payloadWriter.write(resp);
        }

        public void close() throws IOException {
            this.payloadWriter.close();
        }

        public void close(Throwable cause) throws IOException {
            this.payloadWriter.close(cause);
        }

        public void flush() throws IOException {
            this.payloadWriter.flush();
        }

        HttpPayloadWriter<Resp> payloadWriter() {
            return this.payloadWriter;
        }
    }

    static final class Builder {
        private static final String SINGLE_MESSAGE_EXPECTED_NONE_RECEIVED_MSG = "Single request message was expected, but none was received";
        private static final String MORE_THAN_ONE_MESSAGE_RECEIVED_MSG = "More than one request message received";
        private final Map<String, RouteProvider> routes;
        private final Map<String, RouteProvider> streamingRoutes;
        private final Map<String, RouteProvider> blockingRoutes;
        private final Map<String, RouteProvider> blockingStreamingRoutes;
        private final Map<String, GrpcExecutionStrategy> executionStrategies;

        Builder() {
            this.routes = new HashMap<String, RouteProvider>();
            this.streamingRoutes = new HashMap<String, RouteProvider>();
            this.blockingRoutes = new HashMap<String, RouteProvider>();
            this.blockingStreamingRoutes = new HashMap<String, RouteProvider>();
            this.executionStrategies = new HashMap<String, GrpcExecutionStrategy>();
        }

        Builder(Map<String, RouteProvider> routes, Map<String, RouteProvider> streamingRoutes, Map<String, RouteProvider> blockingRoutes, Map<String, RouteProvider> blockingStreamingRoutes, Map<String, GrpcExecutionStrategy> executionStrategies) {
            this.routes = routes;
            this.streamingRoutes = streamingRoutes;
            this.blockingRoutes = blockingRoutes;
            this.blockingStreamingRoutes = blockingStreamingRoutes;
            this.executionStrategies = executionStrategies;
        }

        RouteProviders drainRoutes() {
            HashMap<String, RouteProvider> allRoutes = new HashMap<String, RouteProvider>();
            allRoutes.putAll(this.routes);
            allRoutes.putAll(this.streamingRoutes);
            allRoutes.putAll(this.blockingRoutes);
            allRoutes.putAll(this.blockingStreamingRoutes);
            this.routes.clear();
            this.streamingRoutes.clear();
            this.blockingRoutes.clear();
            this.blockingStreamingRoutes.clear();
            return new RouteProviders(allRoutes);
        }

        GrpcExecutionStrategy executionStrategyFor(String path, GrpcExecutionStrategy defaultValue) {
            return this.executionStrategies.getOrDefault(path, defaultValue);
        }

        static Builder merge(Builder ... builders) {
            HashMap<String, RouteProvider> routes = new HashMap<String, RouteProvider>();
            HashMap<String, RouteProvider> streamingRoutes = new HashMap<String, RouteProvider>();
            HashMap<String, RouteProvider> blockingRoutes = new HashMap<String, RouteProvider>();
            HashMap<String, RouteProvider> blockingStreamingRoutes = new HashMap<String, RouteProvider>();
            HashMap<String, GrpcExecutionStrategy> executionStrategies = new HashMap<String, GrpcExecutionStrategy>();
            for (Builder builder : builders) {
                Builder.mergeRoutes(routes, builder.routes);
                Builder.mergeRoutes(streamingRoutes, builder.streamingRoutes);
                Builder.mergeRoutes(blockingRoutes, builder.blockingRoutes);
                Builder.mergeRoutes(blockingStreamingRoutes, builder.blockingStreamingRoutes);
                executionStrategies.putAll(builder.executionStrategies);
            }
            return new Builder(routes, streamingRoutes, blockingRoutes, blockingStreamingRoutes, executionStrategies);
        }

        private static void mergeRoutes(Map<String, RouteProvider> first, Map<String, RouteProvider> second) {
            for (Map.Entry<String, RouteProvider> entry : second.entrySet()) {
                String path = entry.getKey();
                GrpcRouter.verifyNoOverrides(first.put(path, entry.getValue()), path, Collections.emptyMap());
            }
        }

        <Req, Resp> Builder addRoute(final String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.Route<Req, Resp> route, final Class<Req> requestClass, final Class<Resp> responseClass, final GrpcSerializationProvider serializationProvider) {
            GrpcRouter.verifyNoOverrides(this.routes.put(path, new RouteProvider(executionContext -> HttpApiConversions.toStreamingHttpService((HttpService)new HttpService(){

                public Single<HttpResponse> handle(HttpServiceContext ctx, HttpRequest request, HttpResponseFactory responseFactory) {
                    DefaultGrpcServiceContext serviceContext = null;
                    try {
                        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
                        ContentCodec responseEncoding = GrpcUtils.negotiateAcceptedEncoding((HttpMetaData)request, supportedCodings);
                        serviceContext = new DefaultGrpcServiceContext(request.path(), ctx, supportedCodings);
                        HttpDeserializer deserializer = serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)request, supportedCodings), requestClass);
                        DefaultGrpcServiceContext finalServiceContext = serviceContext;
                        return route.handle(serviceContext, request.payloadBody(deserializer)).map(rawResp -> GrpcUtils.newResponse(responseFactory, finalServiceContext, ctx.executionContext().bufferAllocator()).payloadBody(rawResp, serializationProvider.serializerFor(responseEncoding, responseClass))).onErrorReturn(cause -> {
                            LOGGER.debug("Unexpected exception from aggregated response for path : {}", (Object)path, cause);
                            return GrpcUtils.newErrorResponse(responseFactory, finalServiceContext, null, cause, ctx.executionContext().bufferAllocator());
                        });
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception from aggregated endpoint for path: {}", (Object)path, (Object)t);
                        return Single.succeeded((Object)GrpcUtils.newErrorResponse(responseFactory, (GrpcServiceContext)serviceContext, null, t, ctx.executionContext().bufferAllocator()));
                    }
                }

                public Completable closeAsync() {
                    return route.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return route.closeAsyncGracefully();
                }
            }, strategy -> executionStrategy == null ? strategy : executionStrategy), () -> GrpcRouteConversions.toStreaming(route), () -> GrpcRouteConversions.toRequestStreamingRoute(route), () -> GrpcRouteConversions.toResponseStreamingRoute(route), () -> route, route)), path, this.blockingRoutes);
            this.executionStrategies.put(path, executionStrategy);
            return this;
        }

        <Req, Resp> Builder addStreamingRoute(final String path, final @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.StreamingRoute<Req, Resp> route, final Class<Req> requestClass, final Class<Resp> responseClass, final GrpcSerializationProvider serializationProvider) {
            GrpcRouter.verifyNoOverrides(this.streamingRoutes.put(path, new RouteProvider(executionContext -> {
                final StreamingHttpService service = new StreamingHttpService(){

                    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                        DefaultGrpcServiceContext serviceContext = null;
                        try {
                            List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
                            ContentCodec responseEncoding = GrpcUtils.negotiateAcceptedEncoding((HttpMetaData)request, supportedCodings);
                            serviceContext = new DefaultGrpcServiceContext(request.path(), ctx, supportedCodings);
                            HttpDeserializer deserializer = serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)request, supportedCodings), requestClass);
                            Publisher response = route.handle(serviceContext, request.payloadBody(deserializer));
                            return Single.succeeded((Object)GrpcUtils.newResponse(responseFactory, serviceContext, response, serializationProvider.serializerFor(responseEncoding, responseClass), ctx.executionContext().bufferAllocator()));
                        }
                        catch (Throwable t) {
                            LOGGER.debug("Unexpected exception from streaming endpoint for path: {}", (Object)path, (Object)t);
                            return Single.succeeded((Object)GrpcUtils.newErrorResponse(responseFactory, (GrpcServiceContext)serviceContext, null, t, ctx.executionContext().bufferAllocator()));
                        }
                    }

                    public Completable closeAsync() {
                        return route.closeAsync();
                    }

                    public Completable closeAsyncGracefully() {
                        return route.closeAsyncGracefully();
                    }
                };
                return new HttpApiConversions.ServiceAdapterHolder(){

                    public StreamingHttpService adaptor() {
                        return service;
                    }

                    public HttpExecutionStrategy serviceInvocationStrategy() {
                        return executionStrategy == null ? HttpExecutionStrategies.defaultStrategy() : executionStrategy;
                    }
                };
            }, () -> route, () -> GrpcRouteConversions.toRequestStreamingRoute(route), () -> GrpcRouteConversions.toResponseStreamingRoute(route), () -> GrpcRouteConversions.toRoute(route), route)), path, this.blockingStreamingRoutes);
            this.executionStrategies.put(path, executionStrategy);
            return this;
        }

        <Req, Resp> Builder addRequestStreamingRoute(String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.RequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
            return this.addStreamingRoute(path, executionStrategy, new GrpcRoutes.StreamingRoute<Req, Resp>(){

                @Override
                public Publisher<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                    return route.handle(ctx, request).toPublisher();
                }

                @Override
                public Completable closeAsync() {
                    return route.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return route.closeAsyncGracefully();
                }
            }, requestClass, responseClass, serializationProvider);
        }

        <Req, Resp> Builder addResponseStreamingRoute(String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.ResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
            return this.addStreamingRoute(path, executionStrategy, new GrpcRoutes.StreamingRoute<Req, Resp>(){

                @Override
                public Publisher<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                    return request.firstOrError().onErrorMap(t -> {
                        if (t instanceof NoSuchElementException) {
                            return new GrpcStatus(GrpcStatusCode.INVALID_ARGUMENT, (Throwable)t, Builder.SINGLE_MESSAGE_EXPECTED_NONE_RECEIVED_MSG).asException();
                        }
                        if (t instanceof IllegalArgumentException) {
                            return new GrpcStatus(GrpcStatusCode.INVALID_ARGUMENT, (Throwable)t, Builder.MORE_THAN_ONE_MESSAGE_RECEIVED_MSG).asException();
                        }
                        return t;
                    }).flatMapPublisher(rawReq -> route.handle(ctx, rawReq));
                }

                @Override
                public Completable closeAsync() {
                    return route.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return route.closeAsyncGracefully();
                }
            }, requestClass, responseClass, serializationProvider);
        }

        <Req, Resp> Builder addBlockingRoute(final String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.BlockingRoute<Req, Resp> route, final Class<Req> requestClass, final Class<Resp> responseClass, final GrpcSerializationProvider serializationProvider) {
            GrpcRouter.verifyNoOverrides(this.blockingRoutes.put(path, new RouteProvider(executionContext -> HttpApiConversions.toStreamingHttpService((BlockingHttpService)new BlockingHttpService(){

                public HttpResponse handle(HttpServiceContext ctx, HttpRequest request, HttpResponseFactory responseFactory) {
                    DefaultGrpcServiceContext serviceContext = null;
                    try {
                        List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
                        ContentCodec responseEncoding = GrpcUtils.negotiateAcceptedEncoding((HttpMetaData)request, supportedCodings);
                        serviceContext = new DefaultGrpcServiceContext(request.path(), ctx, supportedCodings);
                        HttpDeserializer deserializer = serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)request, supportedCodings), requestClass);
                        Object response = route.handle(serviceContext, request.payloadBody(deserializer));
                        return GrpcUtils.newResponse(responseFactory, serviceContext, ctx.executionContext().bufferAllocator()).payloadBody(response, serializationProvider.serializerFor(responseEncoding, responseClass));
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception from blocking aggregated endpoint for path: {}", (Object)path, (Object)t);
                        return GrpcUtils.newErrorResponse(responseFactory, (GrpcServiceContext)serviceContext, null, t, ctx.executionContext().bufferAllocator());
                    }
                }

                public void close() throws Exception {
                    route.close();
                }

                public void closeGracefully() throws Exception {
                    route.closeGracefully();
                }
            }, strategy -> executionStrategy == null ? strategy : executionStrategy), () -> GrpcRouteConversions.toStreaming(route), () -> GrpcRouteConversions.toRequestStreamingRoute(route), () -> GrpcRouteConversions.toResponseStreamingRoute(route), () -> GrpcRouteConversions.toRoute(route), route)), path, this.routes);
            this.executionStrategies.put(path, executionStrategy);
            return this;
        }

        <Req, Resp> Builder addBlockingStreamingRoute(String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.BlockingStreamingRoute<Req, Resp> route, final Class<Req> requestClass, final Class<Resp> responseClass, final GrpcSerializationProvider serializationProvider) {
            GrpcRouter.verifyNoOverrides(this.blockingStreamingRoutes.put(path, new RouteProvider(executionContext -> HttpApiConversions.toStreamingHttpService((BlockingStreamingHttpService)new BlockingStreamingHttpService(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(HttpServiceContext ctx, BlockingStreamingHttpRequest request, BlockingStreamingHttpServerResponse response) throws Exception {
                    List<ContentCodec> supportedCodings = serializationProvider.supportedMessageCodings();
                    ContentCodec responseEncoding = GrpcUtils.negotiateAcceptedEncoding((HttpMetaData)request, supportedCodings);
                    DefaultGrpcServiceContext serviceContext = new DefaultGrpcServiceContext(request.path(), ctx, supportedCodings);
                    HttpDeserializer deserializer = serializationProvider.deserializerFor(GrpcUtils.readGrpcMessageEncoding((HttpMetaData)request, supportedCodings), requestClass);
                    HttpSerializer serializer = serializationProvider.serializerFor(responseEncoding, responseClass);
                    DefaultGrpcPayloadWriter grpcPayloadWriter = new DefaultGrpcPayloadWriter(response.sendMetaData(serializer));
                    try {
                        HttpPayloadWriter payloadWriter = grpcPayloadWriter.payloadWriter();
                        GrpcUtils.setStatusOk(payloadWriter.trailers(), ctx.executionContext().bufferAllocator());
                        route.handle(serviceContext, request.payloadBody(deserializer), grpcPayloadWriter);
                    }
                    catch (Throwable t) {
                        try {
                            HttpPayloadWriter payloadWriter = grpcPayloadWriter.payloadWriter();
                            GrpcUtils.setStatus(payloadWriter.trailers(), t, ctx.executionContext().bufferAllocator());
                        }
                        finally {
                            grpcPayloadWriter.close();
                        }
                    }
                }

                public void close() throws Exception {
                    route.close();
                }

                public void closeGracefully() throws Exception {
                    route.closeGracefully();
                }
            }, strategy -> executionStrategy == null ? strategy : executionStrategy), () -> GrpcRouteConversions.toStreaming(route), () -> GrpcRouteConversions.toRequestStreamingRoute(route), () -> GrpcRouteConversions.toResponseStreamingRoute(route), () -> GrpcRouteConversions.toRoute(route), route)), path, this.streamingRoutes);
            this.executionStrategies.put(path, executionStrategy);
            return this;
        }

        <Req, Resp> Builder addBlockingRequestStreamingRoute(String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.BlockingRequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
            return this.addBlockingStreamingRoute(path, executionStrategy, new GrpcRoutes.BlockingStreamingRoute<Req, Resp>(){

                @Override
                public void handle(GrpcServiceContext ctx, BlockingIterable<Req> request, GrpcPayloadWriter<Resp> responseWriter) throws Exception {
                    Object resp = route.handle(ctx, request);
                    responseWriter.write(resp);
                    responseWriter.close();
                }

                @Override
                public void close() throws Exception {
                    route.close();
                }

                public void closeGracefully() throws Exception {
                    route.closeGracefully();
                }
            }, requestClass, responseClass, serializationProvider);
        }

        <Req, Resp> Builder addBlockingResponseStreamingRoute(String path, @Nullable GrpcExecutionStrategy executionStrategy, final GrpcRoutes.BlockingResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
            return this.addBlockingStreamingRoute(path, executionStrategy, new GrpcRoutes.BlockingStreamingRoute<Req, Resp>(){

                @Override
                public void handle(GrpcServiceContext ctx, BlockingIterable<Req> request, GrpcPayloadWriter<Resp> responseWriter) throws Exception {
                    Object firstItem;
                    try (BlockingIterator requestIterator = request.iterator();){
                        if (!requestIterator.hasNext()) {
                            throw new GrpcStatus(GrpcStatusCode.INVALID_ARGUMENT, null, Builder.SINGLE_MESSAGE_EXPECTED_NONE_RECEIVED_MSG).asException();
                        }
                        firstItem = requestIterator.next();
                        assert (firstItem != null);
                        if (requestIterator.hasNext()) {
                            requestIterator.next();
                            throw new GrpcStatus(GrpcStatusCode.INVALID_ARGUMENT, null, Builder.MORE_THAN_ONE_MESSAGE_RECEIVED_MSG).asException();
                        }
                    }
                    route.handle(ctx, firstItem, responseWriter);
                }

                @Override
                public void close() throws Exception {
                    route.close();
                }

                public void closeGracefully() throws Exception {
                    route.closeGracefully();
                }
            }, requestClass, responseClass, serializationProvider);
        }

        public GrpcRouter build() {
            return new GrpcRouter(this.routes, this.streamingRoutes, this.blockingRoutes, this.blockingStreamingRoutes);
        }
    }
}

