/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.grpc.api.GrpcBindableService;
import io.servicetalk.grpc.api.GrpcExceptionMapperServiceFilter;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcServerSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public abstract class GrpcServerBuilder {
    @Deprecated
    protected static final AsyncContextMap.Key<Long> GRPC_DEADLINE_KEY = DeadlineUtils.GRPC_DEADLINE_KEY;

    public GrpcServerBuilder initializeHttp(HttpInitializer initializer) {
        throw new UnsupportedOperationException("Initializing the HttpServerBuilder using this method is not yetsupported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder protocols(HttpProtocolConfig ... protocols) {
        throw new UnsupportedOperationException("Method protocols is not supported by " + this.getClass().getName());
    }

    public abstract GrpcServerBuilder defaultTimeout(Duration var1);

    @Deprecated
    public GrpcServerBuilder backlog(int backlog) {
        this.listenSocketOption(ServiceTalkSocketOptions.SO_BACKLOG, backlog);
        return this;
    }

    @Deprecated
    public abstract GrpcServerSecurityConfigurator secure();

    @Deprecated
    public GrpcServerBuilder sslConfig(ServerSslConfig config) {
        throw new UnsupportedOperationException("Method sslConfig is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        throw new UnsupportedOperationException("Method sslConfig is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public <T> GrpcServerBuilder socketOption(SocketOption<T> option, T value) {
        throw new UnsupportedOperationException("Method socketOption is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public <T> GrpcServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        throw new UnsupportedOperationException("Method listenSocketOption is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder enableWireLogging(String loggerName) {
        throw new UnsupportedOperationException("Method enableWireLogging is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        throw new UnsupportedOperationException("Method enableWireLogging is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder transportObserver(TransportObserver transportObserver) {
        throw new UnsupportedOperationException("Method transportObserver is not supported by " + this.getClass().getName());
    }

    public GrpcServerBuilder lifecycleObserver(GrpcLifecycleObserver lifecycleObserver) {
        throw new UnsupportedOperationException("Setting GrpcLifecycleObserver using this method is not yet supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder disableDrainingRequestPayloadBody() {
        return this.drainRequestPayloadBody(false);
    }

    @Deprecated
    public GrpcServerBuilder drainRequestPayloadBody(boolean enable) {
        throw new UnsupportedOperationException("Method drainRequestPayloadBody is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        throw new UnsupportedOperationException("Method appendConnectionAcceptorFilter is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public final GrpcServerBuilder appendHttpServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.doAppendHttpServiceFilter(factory);
        return this;
    }

    @Deprecated
    public final GrpcServerBuilder appendHttpServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.doAppendHttpServiceFilter(predicate, factory);
        return this;
    }

    @Deprecated
    public GrpcServerBuilder ioExecutor(IoExecutor ioExecutor) {
        throw new UnsupportedOperationException("Method ioExecutor is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder executor(Executor executor) {
        throw new UnsupportedOperationException("Method executor is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder bufferAllocator(BufferAllocator allocator) {
        throw new UnsupportedOperationException("Method bufferAllocator is not supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder executionStrategy(GrpcExecutionStrategy strategy) {
        throw new UnsupportedOperationException("Method executionStrategy is not supported by " + this.getClass().getName());
    }

    public final Single<ServerContext> listen(GrpcBindableService<?, ?, ?> ... services) {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listen(factories);
    }

    public final Single<ServerContext> listen(GrpcServiceFactory<?, ?, ?> ... serviceFactories) {
        return this.doListen(GrpcServiceFactory.merge(serviceFactories));
    }

    public final ServerContext listenAndAwait(GrpcServiceFactory<?, ?, ?> ... serviceFactories) throws Exception {
        return (ServerContext)FutureUtils.awaitResult((Future)this.listen(serviceFactories).toFuture());
    }

    public final ServerContext listenAndAwait(GrpcBindableService<?, ?, ?> ... services) throws Exception {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listenAndAwait(factories);
    }

    protected abstract Single<ServerContext> doListen(GrpcServiceFactory<?, ?, ?> var1);

    protected abstract void doAppendHttpServiceFilter(StreamingHttpServiceFilterFactory var1);

    protected abstract void doAppendHttpServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    @Deprecated
    protected static void appendCatchAllFilter(HttpServerBuilder httpServerBuilder) {
        httpServerBuilder.appendServiceFilter(GrpcExceptionMapperServiceFilter.INSTANCE);
    }

    @FunctionalInterface
    public static interface HttpInitializer {
        public void initialize(HttpServerBuilder var1);

        default public HttpInitializer append(HttpInitializer toAppend) {
            return builder -> {
                this.initialize(builder);
                toAppend.initialize(builder);
            };
        }
    }
}

