/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.GrpcRoutes;
import io.servicetalk.grpc.api.GrpcService;
import io.servicetalk.grpc.api.GrpcServiceFilterFactory;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ServerContext;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class GrpcServiceFactory<Filter extends Service, Service extends GrpcService, FilterFactory extends GrpcServiceFilterFactory<Filter, Service>> {
    private final GrpcRoutes<Service> routes;
    @Nullable
    private FilterFactory filterFactory;

    protected GrpcServiceFactory(GrpcRoutes<Service> routes) {
        this.routes = routes;
    }

    static GrpcServiceFactory<?, ?, ?> merge(GrpcServiceFactory<?, ?, ?> ... factories) {
        if (factories.length == 1) {
            return factories[0];
        }
        GrpcRoutes[] routes = new GrpcRoutes[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            GrpcServiceFactory<?, ?, ?> factory = factories[i];
            if (factory.filterFactory != null) {
                super.applyFilterToRoutes(factory.filterFactory);
            }
            routes[i] = factory.routes;
        }
        return new MergedServiceFactory(routes);
    }

    public final Single<ServerContext> bind(ServerBinder binder, ExecutionContext executionContext) {
        if (this.filterFactory == null) {
            return this.routes.bind(binder, executionContext);
        }
        this.applyFilterToRoutes(this.filterFactory);
        return this.routes.bind(binder, executionContext);
    }

    @Deprecated
    public GrpcServiceFactory<Filter, Service, FilterFactory> appendServiceFilter(FilterFactory before) {
        Objects.requireNonNull(before);
        this.filterFactory = this.filterFactory == null ? before : this.appendServiceFilterFactory(this.filterFactory, before);
        return this;
    }

    @Deprecated
    protected abstract FilterFactory appendServiceFilterFactory(FilterFactory var1, FilterFactory var2);

    private void applyFilterToRoutes(FilterFactory filterFactory) {
        GrpcRoutes.AllGrpcRoutes streamingRoutes = this.routes.drainToStreamingRoutes();
        Service fromRoutes = this.routes.newServiceFromRoutes(streamingRoutes);
        GrpcService filter = (GrpcService)filterFactory.create(fromRoutes);
        this.routes.registerRoutes(filter);
    }

    private static final class MergedServiceFactory
    extends GrpcServiceFactory {
        MergedServiceFactory(GrpcRoutes ... routes) {
            super(GrpcRoutes.merge(routes));
        }

        protected GrpcServiceFilterFactory appendServiceFilterFactory(GrpcServiceFilterFactory existing, GrpcServiceFilterFactory append) {
            throw new UnsupportedOperationException("Merged service factory can not register routes.");
        }
    }

    public static interface ServerBinder {
        public Single<ServerContext> bind(HttpService var1);

        public Single<ServerContext> bindStreaming(StreamingHttpService var1);

        public Single<ServerContext> bindBlocking(BlockingHttpService var1);

        public Single<ServerContext> bindBlockingStreaming(BlockingStreamingHttpService var1);
    }
}

