/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.http.api.Http2ErrorCode;

public enum GrpcStatusCode {
    OK(0),
    CANCELLED(1),
    UNKNOWN(2),
    INVALID_ARGUMENT(3),
    DEADLINE_EXCEEDED(4),
    NOT_FOUND(5),
    ALREADY_EXISTS(6),
    PERMISSION_DENIED(7),
    RESOURCE_EXHAUSTED(8),
    FAILED_PRECONDITION(9),
    ABORTED(10),
    OUT_OF_RANGE(11),
    UNIMPLEMENTED(12),
    INTERNAL(13),
    UNAVAILABLE(14),
    DATA_LOSS(15),
    UNAUTHENTICATED(16);

    private static final GrpcStatusCode[] INT_TO_STATUS_CODE_MAP;
    private static final GrpcStatusCode[] H2_ERROR_TO_STATUS_CODE_MAP;
    private final int value;

    private GrpcStatusCode(int value) {
        this.value = value;
    }

    public static GrpcStatusCode fromCodeValue(CharSequence codeValue) {
        try {
            return GrpcStatusCode.fromCodeValue(Integer.parseInt(codeValue.toString()));
        }
        catch (NumberFormatException e) {
            return UNKNOWN;
        }
    }

    public static GrpcStatusCode fromCodeValue(int codeValue) {
        return codeValue < 0 || codeValue >= INT_TO_STATUS_CODE_MAP.length ? UNKNOWN : INT_TO_STATUS_CODE_MAP[codeValue];
    }

    public int value() {
        return this.value;
    }

    public GrpcStatus status() {
        return GrpcStatus.fromCodeValue(this.value);
    }

    static GrpcStatusCode fromHttp2ErrorCode(Http2ErrorCode errorCode) {
        int h2ErrorCode = errorCode.code();
        return h2ErrorCode < 0 || h2ErrorCode >= H2_ERROR_TO_STATUS_CODE_MAP.length ? UNKNOWN : H2_ERROR_TO_STATUS_CODE_MAP[h2ErrorCode];
    }

    static {
        GrpcStatusCode[] statusCodes = GrpcStatusCode.values();
        INT_TO_STATUS_CODE_MAP = new GrpcStatusCode[statusCodes.length];
        GrpcStatusCode[] grpcStatusCodeArray = statusCodes;
        int n = grpcStatusCodeArray.length;
        for (int i = 0; i < n; ++i) {
            GrpcStatusCode code;
            GrpcStatusCode.INT_TO_STATUS_CODE_MAP[code.value()] = code = grpcStatusCodeArray[i];
        }
        H2_ERROR_TO_STATUS_CODE_MAP = new GrpcStatusCode[Http2ErrorCode.HTTP_1_1_REQUIRED.code() + 1];
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.NO_ERROR.code()] = UNAVAILABLE;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.PROTOCOL_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.INTERNAL_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.FLOW_CONTROL_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.SETTINGS_TIMEOUT.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.STREAM_CLOSED.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.FRAME_SIZE_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.REFUSED_STREAM.code()] = UNAVAILABLE;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.CANCEL.code()] = CANCELLED;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.COMPRESSION_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.CONNECT_ERROR.code()] = INTERNAL;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.ENHANCE_YOUR_CALM.code()] = RESOURCE_EXHAUSTED;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.INADEQUATE_SECURITY.code()] = PERMISSION_DENIED;
        GrpcStatusCode.H2_ERROR_TO_STATUS_CODE_MAP[Http2ErrorCode.HTTP_1_1_REQUIRED.code()] = UNKNOWN;
    }
}

