/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import com.google.rpc.Status;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class GrpcStatusException
extends RuntimeException {
    private static final long serialVersionUID = -1882895535544626915L;
    private final GrpcStatus status;
    private final Supplier<Status> applicationStatusSupplier;

    GrpcStatusException(GrpcStatus status, Supplier<Status> applicationStatusSupplier) {
        super(GrpcStatusException.toMessage(status), status.cause());
        this.status = status;
        this.applicationStatusSupplier = Objects.requireNonNull(applicationStatusSupplier);
    }

    public GrpcStatus status() {
        return this.status;
    }

    @Nullable
    public Status applicationStatus() {
        return this.applicationStatusSupplier.get();
    }

    public static GrpcStatusException of(Status status) {
        return new GrpcStatusException(new GrpcStatus(GrpcStatusCode.fromCodeValue(status.getCode()), null, status.getMessage()), () -> status);
    }

    private static String toMessage(GrpcStatus status) {
        return status.description() == null ? status.code().toString() : (Object)((Object)status.code()) + ": " + status.description();
    }
}

