/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.encoding.api.internal.HeaderUtils;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.grpc.api.MessageEncodingException;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.http.api.Http2Exception;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.StatelessTrailersTransformer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.TrailersTransformer;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrpcUtils {
    private static final CharSequence GRPC_CONTENT_TYPE = CharSequences.newAsciiString((String)"application/grpc");
    static final CharSequence GRPC_STATUS_CODE_TRAILER = CharSequences.newAsciiString((String)"grpc-status");
    private static final CharSequence GRPC_STATUS_DETAILS_TRAILER = CharSequences.newAsciiString((String)"grpc-status-details-bin");
    private static final CharSequence GRPC_STATUS_MESSAGE_TRAILER = CharSequences.newAsciiString((String)"grpc-message");
    private static final CharSequence GRPC_USER_AGENT = CharSequences.newAsciiString((String)"grpc-service-talk/");
    private static final CharSequence GRPC_MESSAGE_ENCODING_KEY = CharSequences.newAsciiString((String)"grpc-encoding");
    private static final CharSequence GRPC_ACCEPT_ENCODING_KEY = CharSequences.newAsciiString((String)"grpc-accept-encoding");
    private static final GrpcStatus STATUS_OK = GrpcStatus.fromCodeValue(GrpcStatusCode.OK.value());
    private static final ConcurrentMap<List<ContentCodec>, CharSequence> ENCODINGS_HEADER_CACHE = new ConcurrentHashMap<List<ContentCodec>, CharSequence>();
    private static final CharSequence CONTENT_ENCODING_SEPARATOR = ", ";
    private static final TrailersTransformer<Object, Buffer> ENSURE_GRPC_STATUS_RECEIVED = new StatelessTrailersTransformer<Buffer>(){

        protected HttpHeaders payloadComplete(HttpHeaders trailers) {
            GrpcUtils.ensureGrpcStatusReceived(trailers);
            return trailers;
        }

        protected HttpHeaders payloadFailed(Throwable cause, HttpHeaders trailers) throws Throwable {
            if (cause instanceof CancellationException) {
                throw new GrpcStatusException(new GrpcStatus(GrpcStatusCode.CANCELLED, cause), () -> null);
            }
            if (cause instanceof TimeoutException) {
                throw new GrpcStatusException(new GrpcStatus(GrpcStatusCode.DEADLINE_EXCEEDED, cause), () -> null);
            }
            throw cause;
        }
    };

    private GrpcUtils() {
    }

    static void initRequest(HttpRequestMetaData request, List<ContentCodec> supportedEncodings, @Nullable Duration timeout) {
        assert (HttpRequestMethod.POST.equals((Object)request.method()));
        HttpHeaders headers = request.headers();
        CharSequence timeoutValue = DeadlineUtils.makeTimeoutHeader((Duration)timeout);
        if (null != timeoutValue) {
            headers.set(DeadlineUtils.GRPC_TIMEOUT_HEADER_KEY, timeoutValue);
        }
        headers.set(HttpHeaderNames.USER_AGENT, GRPC_USER_AGENT);
        headers.set(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
        headers.set(HttpHeaderNames.CONTENT_TYPE, GRPC_CONTENT_TYPE);
        CharSequence acceptedEncoding = GrpcUtils.acceptedEncodingsHeaderValueOrCached(supportedEncodings);
        if (acceptedEncoding != null) {
            headers.set(GRPC_ACCEPT_ENCODING_KEY, acceptedEncoding);
        }
    }

    static <T> StreamingHttpResponse newResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, Publisher<T> payload, HttpSerializer<T> serializer, BufferAllocator allocator) {
        return GrpcUtils.newStreamingResponse(responseFactory, context).payloadBody(payload, serializer).transform((TrailersTransformer)new GrpcStatusUpdater(allocator, STATUS_OK));
    }

    static StreamingHttpResponse newResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, GrpcStatus status, BufferAllocator allocator) {
        return GrpcUtils.newStreamingResponse(responseFactory, context).transform((TrailersTransformer)new GrpcStatusUpdater(allocator, status));
    }

    static HttpResponse newResponse(HttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, BufferAllocator allocator) {
        HttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        GrpcUtils.setStatusOk(response.trailers(), allocator);
        return response;
    }

    static HttpResponse newErrorResponse(HttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, @Nullable GrpcStatus status, @Nullable Throwable cause, BufferAllocator allocator) {
        assert (status != null || cause != null);
        HttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        if (status != null) {
            GrpcUtils.setStatus(response.headers(), status, null, allocator);
        } else {
            GrpcUtils.setStatus(response.headers(), cause, allocator);
        }
        return response;
    }

    static StreamingHttpResponse newErrorResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context, @Nullable GrpcStatus status, @Nullable Throwable cause, BufferAllocator allocator) {
        assert (status != null && cause == null || status == null && cause != null);
        StreamingHttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        if (status != null) {
            GrpcUtils.setStatus(response.headers(), status, null, allocator);
        } else {
            GrpcUtils.setStatus(response.headers(), cause, allocator);
        }
        return response;
    }

    private static StreamingHttpResponse newStreamingResponse(StreamingHttpResponseFactory responseFactory, @Nullable GrpcServiceContext context) {
        StreamingHttpResponse response = responseFactory.ok();
        GrpcUtils.initResponse((HttpResponseMetaData)response, context);
        return response;
    }

    static void setStatusOk(HttpHeaders trailers, BufferAllocator allocator) {
        GrpcUtils.setStatus(trailers, STATUS_OK, null, allocator);
    }

    static void setStatus(HttpHeaders trailers, GrpcStatus status, @Nullable Status details, BufferAllocator allocator) {
        trailers.set(GRPC_STATUS_CODE_TRAILER, (CharSequence)String.valueOf(status.code().value()));
        if (status.description() != null) {
            trailers.set(GRPC_STATUS_MESSAGE_TRAILER, (CharSequence)status.description());
        }
        if (details != null) {
            trailers.set(GRPC_STATUS_DETAILS_TRAILER, CharSequences.newAsciiString((Buffer)allocator.wrap(Base64.getEncoder().encode(details.toByteArray()))));
        }
    }

    static void setStatus(HttpHeaders trailers, Throwable cause, BufferAllocator allocator) {
        if (cause instanceof GrpcStatusException) {
            GrpcStatusException grpcStatusException = (GrpcStatusException)cause;
            GrpcUtils.setStatus(trailers, grpcStatusException.status(), grpcStatusException.applicationStatus(), allocator);
        } else {
            GrpcUtils.setStatus(trailers, GrpcUtils.toGrpcStatus(cause), null, allocator);
        }
    }

    static GrpcStatus toGrpcStatus(Throwable cause) {
        GrpcStatus status;
        if (cause instanceof Http2Exception) {
            Http2Exception h2Exception = (Http2Exception)cause;
            status = new GrpcStatus(GrpcStatusCode.fromHttp2ErrorCode(h2Exception.errorCode()), cause);
        } else if (cause instanceof MessageEncodingException) {
            MessageEncodingException msgEncException = (MessageEncodingException)cause;
            status = new GrpcStatus(GrpcStatusCode.UNIMPLEMENTED, cause, "Message encoding '" + msgEncException.encoding() + "' not supported ");
        } else {
            status = cause instanceof CancellationException ? new GrpcStatus(GrpcStatusCode.CANCELLED, cause) : (cause instanceof TimeoutException ? new GrpcStatus(GrpcStatusCode.DEADLINE_EXCEEDED, cause) : new GrpcStatus(GrpcStatusCode.UNKNOWN, cause, cause.toString()));
        }
        return status;
    }

    static GrpcStatusException toGrpcException(Throwable cause) {
        return cause instanceof GrpcStatusException ? (GrpcStatusException)cause : new GrpcStatusException(GrpcUtils.toGrpcStatus(cause), () -> null);
    }

    static <Resp> Publisher<Resp> validateResponseAndGetPayload(StreamingHttpResponse response, HttpDeserializer<Resp> deserializer) {
        HttpHeaders headers = response.headers();
        GrpcUtils.ensureGrpcContentType(response.status(), headers);
        GrpcStatusCode grpcStatusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(headers);
        if (grpcStatusCode != null) {
            GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(grpcStatusCode, headers);
            if (grpcStatusException != null) {
                return Publisher.failed((Throwable)grpcStatusException).concat(response.messageBody().ignoreElements());
            }
            return response.messageBody().ignoreElements().toPublisher();
        }
        response.transform(ENSURE_GRPC_STATUS_RECEIVED);
        return deserializer.deserialize(headers, response.payloadBody());
    }

    static <Resp> Resp validateResponseAndGetPayload(HttpResponse response, HttpDeserializer<Resp> deserializer) {
        HttpHeaders headers = response.headers();
        HttpHeaders trailers = response.trailers();
        GrpcUtils.ensureGrpcContentType(response.status(), headers);
        GrpcStatusCode grpcStatusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(trailers);
        if (grpcStatusCode != null) {
            GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(grpcStatusCode, trailers);
            if (grpcStatusException != null) {
                throw grpcStatusException;
            }
            return (Resp)response.payloadBody(deserializer);
        }
        GrpcUtils.ensureGrpcStatusReceived(headers);
        return (Resp)response.payloadBody(deserializer);
    }

    private static void ensureGrpcContentType(HttpResponseStatus status, HttpHeaders headers) {
        CharSequence contentTypeHeader = headers.get(HttpHeaderNames.CONTENT_TYPE);
        if (!io.servicetalk.http.api.HeaderUtils.hasContentType((HttpHeaders)headers, (CharSequence)GRPC_CONTENT_TYPE, null)) {
            throw new GrpcStatus(GrpcStatusCode.INTERNAL, null, "HTTP status code: " + status + "\n\tinvalid " + HttpHeaderNames.CONTENT_TYPE + ": " + contentTypeHeader + "\n\theaders: " + headers).asException();
        }
    }

    private static void ensureGrpcStatusReceived(HttpHeaders headers) {
        GrpcStatusCode statusCode = GrpcUtils.extractGrpcStatusCodeFromHeaders(headers);
        if (statusCode == null) {
            throw new GrpcStatus(GrpcStatusCode.UNKNOWN, null, "Response does not contain " + GRPC_STATUS_CODE_TRAILER + " header or trailer").asException();
        }
        GrpcStatusException grpcStatusException = GrpcUtils.convertToGrpcStatusException(statusCode, headers);
        if (grpcStatusException != null) {
            throw grpcStatusException;
        }
    }

    static ContentCodec readGrpcMessageEncoding(HttpMetaData httpMetaData, List<ContentCodec> allowedEncodings) {
        CharSequence encoding = httpMetaData.headers().get(GRPC_MESSAGE_ENCODING_KEY);
        if (encoding == null) {
            return Identity.identity();
        }
        ContentCodec enc = HeaderUtils.encodingFor(allowedEncodings, (CharSequence)encoding);
        if (enc == null) {
            throw new MessageEncodingException(encoding.toString());
        }
        return enc;
    }

    static ContentCodec negotiateAcceptedEncoding(HttpMetaData httpMetaData, List<ContentCodec> allowedCodings) {
        CharSequence acceptEncHeaderValue = httpMetaData.headers().get(GRPC_ACCEPT_ENCODING_KEY);
        ContentCodec encoding = HeaderUtils.negotiateAcceptedEncoding((CharSequence)acceptEncHeaderValue, allowedCodings);
        return encoding == null ? Identity.identity() : encoding;
    }

    private static void initResponse(HttpResponseMetaData response, @Nullable GrpcServiceContext context) {
        CharSequence acceptedEncoding;
        HttpHeaders headers = response.headers();
        headers.set(HttpHeaderNames.SERVER, GRPC_USER_AGENT);
        headers.set(HttpHeaderNames.CONTENT_TYPE, GRPC_CONTENT_TYPE);
        if (context != null && (acceptedEncoding = GrpcUtils.acceptedEncodingsHeaderValueOrCached(context.supportedMessageCodings())) != null) {
            headers.set(GRPC_ACCEPT_ENCODING_KEY, acceptedEncoding);
        }
    }

    @Nullable
    private static GrpcStatusCode extractGrpcStatusCodeFromHeaders(HttpHeaders headers) {
        CharSequence statusCode = headers.get(GRPC_STATUS_CODE_TRAILER);
        if (statusCode == null) {
            return null;
        }
        return GrpcStatusCode.fromCodeValue(statusCode);
    }

    @Nullable
    private static GrpcStatusException convertToGrpcStatusException(GrpcStatusCode grpcStatusCode, HttpHeaders headers) {
        if (grpcStatusCode.value() == GrpcStatusCode.OK.value()) {
            return null;
        }
        GrpcStatus grpcStatus = new GrpcStatus(grpcStatusCode, null, headers.get(GRPC_STATUS_MESSAGE_TRAILER));
        return grpcStatus.asException(new StatusSupplier(headers, grpcStatus));
    }

    @Nullable
    private static Status getStatusDetails(HttpHeaders headers) {
        CharSequence details = headers.get(GRPC_STATUS_DETAILS_TRAILER);
        if (details == null) {
            return null;
        }
        try {
            return (Status)Status.parser().parseFrom(Base64.getDecoder().decode(details.toString()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Could not decode grpc status details", e);
        }
    }

    @Nullable
    private static CharSequence acceptedEncodingsHeaderValueOrCached(List<ContentCodec> codings) {
        return ENCODINGS_HEADER_CACHE.computeIfAbsent(codings, __ -> GrpcUtils.acceptedEncodingsHeaderValue0(codings));
    }

    @Nullable
    private static CharSequence acceptedEncodingsHeaderValue0(List<ContentCodec> codings) {
        StringBuilder builder = new StringBuilder(codings.size() * (12 + CONTENT_ENCODING_SEPARATOR.length()));
        for (ContentCodec codec : codings) {
            if (Identity.identity().equals(codec)) continue;
            builder.append(codec.name()).append(CONTENT_ENCODING_SEPARATOR);
        }
        if (builder.length() > CONTENT_ENCODING_SEPARATOR.length()) {
            builder.setLength(builder.length() - CONTENT_ENCODING_SEPARATOR.length());
            return CharSequences.newAsciiString((CharSequence)builder);
        }
        return null;
    }

    static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    private static final class GrpcStatusUpdater
    extends StatelessTrailersTransformer<Buffer> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GrpcStatusUpdater.class);
        private final BufferAllocator allocator;
        private final GrpcStatus successStatus;

        GrpcStatusUpdater(BufferAllocator allocator, GrpcStatus successStatus) {
            this.allocator = allocator;
            this.successStatus = successStatus;
        }

        protected HttpHeaders payloadComplete(HttpHeaders trailers) {
            GrpcUtils.setStatus(trailers, this.successStatus, null, this.allocator);
            return trailers;
        }

        protected HttpHeaders payloadFailed(Throwable cause, HttpHeaders trailers) {
            GrpcUtils.setStatus(trailers, cause, this.allocator);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Converted an exception into grpc-status: {}", (Object)trailers.get(GRPC_STATUS_CODE_TRAILER), (Object)cause);
            }
            return trailers;
        }
    }

    private static final class StatusSupplier
    implements Supplier<Status> {
        private final HttpHeaders headers;
        private final GrpcStatus fallbackStatus;
        @Nullable
        private volatile StatusHolder statusHolder;

        StatusSupplier(HttpHeaders headers, GrpcStatus fallbackStatus) {
            this.headers = headers;
            this.fallbackStatus = fallbackStatus;
        }

        @Override
        @Nullable
        public Status get() {
            StatusHolder statusHolder = this.statusHolder;
            if (statusHolder == null) {
                Status statusFromHeaders = GrpcUtils.getStatusDetails(this.headers);
                if (statusFromHeaders == null) {
                    Status.Builder builder = Status.newBuilder().setCode(this.fallbackStatus.code().value());
                    if (this.fallbackStatus.description() != null) {
                        builder.setMessage(this.fallbackStatus.description());
                    }
                    this.statusHolder = statusHolder = new StatusHolder(builder.build());
                } else {
                    this.statusHolder = statusHolder = new StatusHolder(statusFromHeaders);
                }
            }
            return statusHolder.status;
        }

        private static final class StatusHolder {
            @Nullable
            final Status status;

            StatusHolder(@Nullable Status status) {
                this.status = status;
            }
        }
    }
}

