/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.grpc.api.DefaultGrpcMetadata;
import io.servicetalk.grpc.api.GrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public class DefaultGrpcClientMetadata
extends DefaultGrpcMetadata
implements GrpcClientMetadata {
    @Nullable
    private final GrpcExecutionStrategy strategy;
    private final ContentCodec requestEncoding;
    @Nullable
    private final Duration timeout;

    protected DefaultGrpcClientMetadata(String path) {
        this(path, null, Identity.identity(), null);
    }

    protected DefaultGrpcClientMetadata(String path, ContentCodec requestEncoding) {
        this(path, null, requestEncoding, null);
    }

    protected DefaultGrpcClientMetadata(String path, ContentCodec requestEncoding, Duration timeout) {
        this(path, null, requestEncoding, timeout);
    }

    protected DefaultGrpcClientMetadata(String path, @Nullable GrpcExecutionStrategy strategy) {
        this(path, strategy, Identity.identity(), null);
    }

    protected DefaultGrpcClientMetadata(String path, @Nullable GrpcExecutionStrategy strategy, ContentCodec requestEncoding) {
        this(path, strategy, requestEncoding, null);
    }

    protected DefaultGrpcClientMetadata(String path, @Nullable Duration timeout) {
        this(path, null, Identity.identity(), timeout);
    }

    protected DefaultGrpcClientMetadata(String path, @Nullable GrpcExecutionStrategy strategy, @Nullable Duration timeout) {
        this(path, strategy, Identity.identity(), timeout);
    }

    protected DefaultGrpcClientMetadata(String path, @Nullable GrpcExecutionStrategy strategy, ContentCodec requestEncoding, @Nullable Duration timeout) {
        super(path);
        this.strategy = strategy;
        this.requestEncoding = Objects.requireNonNull(requestEncoding, "requestEncoding");
        if (null != timeout) {
            DurationUtils.ensurePositive((Duration)timeout, (String)"timeout");
        }
        this.timeout = DurationUtils.isInfinite((Duration)timeout, (Duration)GRPC_MAX_TIMEOUT) ? null : timeout;
    }

    @Override
    public final GrpcExecutionStrategy strategy() {
        return this.strategy;
    }

    @Override
    public ContentCodec requestEncoding() {
        return this.requestEncoding;
    }

    @Override
    @Nullable
    public Duration timeout() {
        return this.timeout;
    }
}

