/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.grpc.api.DefaultGrpcExecutionContext;
import io.servicetalk.grpc.api.DefaultGrpcMetadata;
import io.servicetalk.grpc.api.GrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.transport.api.ConnectionContext;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

final class DefaultGrpcServiceContext
extends DefaultGrpcMetadata
implements GrpcServiceContext {
    private final ConnectionContext connectionContext;
    private final GrpcExecutionContext executionContext;
    private final GrpcServiceContext.GrpcProtocol protocol;
    private final List<ContentCodec> supportedMessageCodings;

    DefaultGrpcServiceContext(String path, HttpServiceContext httpServiceContext, List<ContentCodec> supportedMessageCodings) {
        super(path);
        this.connectionContext = (ConnectionContext)Objects.requireNonNull(httpServiceContext);
        this.executionContext = new DefaultGrpcExecutionContext(httpServiceContext.executionContext());
        this.protocol = new DefaultGrpcProtocol(httpServiceContext.protocol());
        this.supportedMessageCodings = Collections.unmodifiableList(new ArrayList<ContentCodec>(supportedMessageCodings));
    }

    public SocketAddress localAddress() {
        return this.connectionContext.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.connectionContext.remoteAddress();
    }

    @Nullable
    public SSLSession sslSession() {
        return this.connectionContext.sslSession();
    }

    @Override
    public GrpcExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public List<ContentCodec> supportedMessageCodings() {
        return this.supportedMessageCodings;
    }

    @Nullable
    public <T> T socketOption(SocketOption<T> option) {
        return (T)this.connectionContext.socketOption(option);
    }

    @Override
    public GrpcServiceContext.GrpcProtocol protocol() {
        return this.protocol;
    }

    public Completable onClose() {
        return this.connectionContext.onClose();
    }

    public Completable closeAsync() {
        return this.connectionContext.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.connectionContext.closeAsyncGracefully();
    }

    private static final class DefaultGrpcProtocol
    implements GrpcServiceContext.GrpcProtocol {
        private final HttpProtocolVersion httpProtocol;

        private DefaultGrpcProtocol(HttpProtocolVersion httpProtocol) {
            this.httpProtocol = Objects.requireNonNull(httpProtocol);
        }

        public String name() {
            return "gRPC";
        }

        @Override
        public HttpProtocolVersion httpProtocol() {
            return this.httpProtocol;
        }

        public String toString() {
            return this.name() + "-over-" + this.httpProtocol();
        }
    }
}

