/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.grpc.api.GrpcBindableService;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcServerSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.api.GrpcUtils;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public abstract class GrpcServerBuilder {
    @Deprecated
    protected static final AsyncContextMap.Key<Long> GRPC_DEADLINE_KEY = DeadlineUtils.GRPC_DEADLINE_KEY;
    private boolean appendedCatchAllFilter;

    public abstract GrpcServerBuilder protocols(HttpProtocolConfig ... var1);

    public abstract GrpcServerBuilder defaultTimeout(Duration var1);

    @Deprecated
    public GrpcServerBuilder backlog(int backlog) {
        this.listenSocketOption(ServiceTalkSocketOptions.SO_BACKLOG, backlog);
        return this;
    }

    @Deprecated
    public abstract GrpcServerSecurityConfigurator secure();

    public abstract GrpcServerBuilder sslConfig(ServerSslConfig var1);

    public abstract GrpcServerBuilder sslConfig(ServerSslConfig var1, Map<String, ServerSslConfig> var2);

    public abstract <T> GrpcServerBuilder socketOption(SocketOption<T> var1, T var2);

    public abstract <T> GrpcServerBuilder listenSocketOption(SocketOption<T> var1, T var2);

    @Deprecated
    public abstract GrpcServerBuilder enableWireLogging(String var1);

    public abstract GrpcServerBuilder enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    public abstract GrpcServerBuilder transportObserver(TransportObserver var1);

    public GrpcServerBuilder lifecycleObserver(GrpcLifecycleObserver lifecycleObserver) {
        throw new UnsupportedOperationException("Setting GrpcLifecycleObserver using this method is not yet supported by " + this.getClass().getName());
    }

    @Deprecated
    public GrpcServerBuilder disableDrainingRequestPayloadBody() {
        return this.drainRequestPayloadBody(false);
    }

    public GrpcServerBuilder drainRequestPayloadBody(boolean enable) {
        throw new UnsupportedOperationException("Setting automatic request draining using this method is not yet supported by " + this.getClass().getSimpleName());
    }

    public abstract GrpcServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory var1);

    public final GrpcServerBuilder appendHttpServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.appendCatchAllFilterIfRequired();
        this.doAppendHttpServiceFilter(factory);
        return this;
    }

    public final GrpcServerBuilder appendHttpServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.appendCatchAllFilterIfRequired();
        this.doAppendHttpServiceFilter(predicate, factory);
        return this;
    }

    public abstract GrpcServerBuilder ioExecutor(IoExecutor var1);

    public GrpcServerBuilder executor(Executor executor) {
        throw new UnsupportedOperationException("Setting Executor not yet supported by " + this.getClass().getSimpleName());
    }

    public abstract GrpcServerBuilder bufferAllocator(BufferAllocator var1);

    public abstract GrpcServerBuilder executionStrategy(GrpcExecutionStrategy var1);

    public final Single<ServerContext> listen(GrpcBindableService<?, ?, ?> ... services) {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listen(factories);
    }

    public final Single<ServerContext> listen(GrpcServiceFactory<?, ?, ?> ... serviceFactories) {
        return this.doListen(GrpcServiceFactory.merge(serviceFactories));
    }

    public final ServerContext listenAndAwait(GrpcServiceFactory<?, ?, ?> ... serviceFactories) throws Exception {
        return (ServerContext)FutureUtils.awaitResult((Future)this.listen(serviceFactories).toFuture());
    }

    public final ServerContext listenAndAwait(GrpcBindableService<?, ?, ?> ... services) throws Exception {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listenAndAwait(factories);
    }

    protected abstract Single<ServerContext> doListen(GrpcServiceFactory<?, ?, ?> var1);

    protected abstract void doAppendHttpServiceFilter(StreamingHttpServiceFilterFactory var1);

    protected abstract void doAppendHttpServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    private void appendCatchAllFilterIfRequired() {
        if (!this.appendedCatchAllFilter) {
            this.doAppendHttpServiceFilter(CatchAllHttpServiceFilter::new);
            this.appendedCatchAllFilter = true;
        }
    }

    static final class CatchAllHttpServiceFilter
    extends StreamingHttpServiceFilter {
        CatchAllHttpServiceFilter(StreamingHttpService service) {
            super(service);
        }

        public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
            Single handle;
            try {
                handle = this.delegate().handle(ctx, request, responseFactory);
            }
            catch (Throwable cause2) {
                return Single.succeeded((Object)CatchAllHttpServiceFilter.convertToGrpcErrorResponse(ctx, responseFactory, cause2));
            }
            return handle.onErrorReturn(cause -> CatchAllHttpServiceFilter.convertToGrpcErrorResponse(ctx, responseFactory, cause));
        }

        private static StreamingHttpResponse convertToGrpcErrorResponse(HttpServiceContext ctx, StreamingHttpResponseFactory responseFactory, Throwable cause) {
            return GrpcUtils.newErrorResponse(responseFactory, null, null, cause, ctx.executionContext().bufferAllocator());
        }
    }
}

