/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.ServiceTalkTestTimeout;
import io.servicetalk.http.api.AbstractHttpRequesterFilterTest;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLSession;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=Parameterized.class)
public abstract class AbstractHttpServiceFilterTest {
    private static final StreamingHttpRequestResponseFactory REQ_RES_FACTORY = new DefaultStreamingHttpRequestResponseFactory(BufferAllocators.DEFAULT_ALLOCATOR, DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1);
    @Rule
    public final MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public final Timeout timeout = new ServiceTalkTestTimeout();
    public final SecurityType security;
    @Mock
    private HttpExecutionContext executionContext;
    @Mock
    private HttpServiceContext mockConnectionContext;

    public AbstractHttpServiceFilterTest(SecurityType security) {
        this.security = security;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> securityTypes() {
        return Arrays.asList({SecurityType.Secure}, {SecurityType.Insecure});
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockConnectionContext.executionContext()).thenReturn((Object)this.executionContext);
        Mockito.when((Object)this.mockConnectionContext.remoteAddress()).thenAnswer(__ -> this.remoteAddress());
        Mockito.when((Object)this.mockConnectionContext.localAddress()).thenAnswer(__ -> this.localAddress());
        Mockito.when((Object)this.mockConnectionContext.sslSession()).thenAnswer(__ -> {
            switch (this.security) {
                case Secure: {
                    return this.sslSession();
                }
            }
            return null;
        });
    }

    protected InetSocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.2", 28080);
    }

    protected InetSocketAddress localAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.1", 80);
    }

    protected SSLSession sslSession() {
        return (SSLSession)Mockito.mock(SSLSession.class);
    }

    protected final StreamingHttpRequester createFilter(final AbstractHttpRequesterFilterTest.RequestHandler handler, StreamingHttpServiceFilterFactory factory) {
        final StreamingHttpServiceFilter service = factory.create(new StreamingHttpService(){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return handler.request(responseFactory, request);
            }
        });
        return new StreamingHttpRequester(){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return service.handle(AbstractHttpServiceFilterTest.this.mockConnectionContext, request, (StreamingHttpResponseFactory)REQ_RES_FACTORY);
            }

            public HttpExecutionContext executionContext() {
                return AbstractHttpServiceFilterTest.this.executionContext;
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return REQ_RES_FACTORY;
            }

            public Completable onClose() {
                return Completable.completed();
            }

            public Completable closeAsync() {
                return Completable.completed();
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return REQ_RES_FACTORY.newRequest(method, requestTarget);
            }
        };
    }

    public static enum SecurityType {
        Secure,
        Insecure;

    }
}

