/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.security.auth.basic.jersey;

import java.security.Principal;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.ws.rs.core.SecurityContext;

public final class BasicAuthSecurityContext
implements SecurityContext {
    private final Principal principal;
    private final boolean secure;
    @Nullable
    private final Predicate<String> userInRolePredicate;

    public BasicAuthSecurityContext(Principal principal, boolean secure) {
        this(principal, secure, null);
    }

    public BasicAuthSecurityContext(Principal principal, boolean secure, @Nullable Predicate<String> userInRolePredicate) {
        this.principal = Objects.requireNonNull(principal);
        this.secure = secure;
        this.userInRolePredicate = userInRolePredicate;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.userInRolePredicate != null && this.userInRolePredicate.test(role);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthenticationScheme() {
        return "BASIC";
    }
}

