/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.HostAndPort;
import java.net.InetSocketAddress;
import java.util.Locale;
import javax.annotation.Nullable;

public final class HttpRequestUriUtils {
    private HttpRequestUriUtils() {
    }

    public static String getEffectiveRequestUri(ConnectionContext ctx, HttpRequestMetaData metaData, boolean includeUserInfo) {
        return HttpRequestUriUtils.getEffectiveRequestUri(ctx, metaData, null, null, includeUserInfo);
    }

    public static String getEffectiveRequestUri(ConnectionContext ctx, HttpRequestMetaData metaData, @Nullable String fixedScheme, @Nullable String fixedAuthority, boolean includeUserInfo) {
        return HttpRequestUriUtils.buildEffectiveRequestUri(ctx, metaData, fixedScheme, fixedAuthority, metaData.rawPath(), metaData.rawQuery(), includeUserInfo, true);
    }

    public static String getEffectiveRequestUri(HttpRequestMetaData metaData, String fixedScheme, String fixedAuthority, boolean includeUserInfo) {
        return HttpRequestUriUtils.buildEffectiveRequestUri(null, metaData, fixedScheme, fixedAuthority, metaData.rawPath(), metaData.rawQuery(), includeUserInfo, true);
    }

    public static String getBaseRequestUri(ConnectionContext ctx, HttpRequestMetaData metaData, boolean includeUserInfo) {
        return HttpRequestUriUtils.getBaseRequestUri(ctx, metaData, null, null, includeUserInfo);
    }

    public static String getBaseRequestUri(ConnectionContext ctx, HttpRequestMetaData metaData, @Nullable String fixedScheme, @Nullable String fixedAuthority, boolean includeUserInfo) {
        return HttpRequestUriUtils.buildEffectiveRequestUri(ctx, metaData, fixedScheme, fixedAuthority, "/", null, includeUserInfo, false);
    }

    private static String buildEffectiveRequestUri(@Nullable ConnectionContext ctx, HttpRequestMetaData metaData, @Nullable String fixedScheme, @Nullable String fixedAuthority, @Nullable String path, @Nullable String query, boolean includeUserInfo, boolean checkAuthorityOrAsteriskForm) {
        String scheme;
        String metadataScheme;
        if (fixedScheme != null && !"http".equalsIgnoreCase(fixedScheme) && !"https".equalsIgnoreCase(fixedScheme)) {
            throw new IllegalArgumentException("Unsupported scheme: " + fixedScheme);
        }
        if (ctx == null && (fixedScheme == null || fixedAuthority == null)) {
            throw new IllegalArgumentException("Context required without scheme and authority");
        }
        if (checkAuthorityOrAsteriskForm && (HttpRequestMethod.CONNECT.equals((Object)metaData.method()) || HttpRequestMethod.OPTIONS.equals((Object)metaData.method()))) {
            query = null;
            path = null;
        }
        if ((metadataScheme = metaData.scheme()) != null) {
            return HttpRequestUriUtils.buildRequestUri(metadataScheme, includeUserInfo ? metaData.userInfo() : null, metaData.host(), metaData.port(), path, query);
        }
        String string = fixedScheme != null ? fixedScheme.toLowerCase(Locale.ENGLISH) : (scheme = ctx.sslSession() != null ? "https" : "http");
        if (fixedAuthority != null) {
            return HttpRequestUriUtils.buildRequestUri(scheme, fixedAuthority, path, query);
        }
        HostAndPort effectiveHostAndPort = metaData.effectiveHostAndPort();
        if (effectiveHostAndPort != null) {
            return HttpRequestUriUtils.buildRequestUri(scheme, includeUserInfo ? metaData.userInfo() : null, effectiveHostAndPort.hostName(), effectiveHostAndPort.port(), path, query);
        }
        if (!(ctx.localAddress() instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("ConnectionContext#getLocalAddress is not an InetSocketAddress: " + ctx.localAddress());
        }
        InetSocketAddress localAddress = (InetSocketAddress)ctx.localAddress();
        boolean defaultPort = "http".equals(scheme) && localAddress.getPort() == 80 || "https".equals(scheme) && localAddress.getPort() == 443;
        return HttpRequestUriUtils.buildRequestUri(scheme, null, localAddress.getHostName(), defaultPort ? -1 : localAddress.getPort(), path, query);
    }

    private static String buildRequestUri(String scheme, String authority, @Nullable String path, @Nullable String query) {
        StringBuilder sb = HttpRequestUriUtils.newRequestUriStringBuilder(scheme, authority.length(), path, query).append(authority);
        return HttpRequestUriUtils.appendPathAndQuery(path, query, sb);
    }

    private static String buildRequestUri(String scheme, @Nullable String userInfo, @Nullable String host, int port, @Nullable String path, @Nullable String query) {
        StringBuilder sb = HttpRequestUriUtils.newRequestUriStringBuilder(scheme, (userInfo != null ? userInfo.length() + 1 : 0) + (host != null ? host.length() : 0) + (port >= 0 ? 6 : 0), path, query);
        if (userInfo != null) {
            sb.append(userInfo).append('@');
        }
        if (host != null) {
            sb.append(host);
        }
        if (port >= 0) {
            sb.append(':').append(port);
        }
        return HttpRequestUriUtils.appendPathAndQuery(path, query, sb);
    }

    private static StringBuilder newRequestUriStringBuilder(String scheme, int authorityLength, @Nullable String path, @Nullable String query) {
        return new StringBuilder(scheme.length() + 3 + authorityLength + (path != null ? path.length() : 0) + (query != null ? query.length() + 1 : 0)).append(scheme).append("://");
    }

    private static String appendPathAndQuery(@Nullable String path, @Nullable String query, StringBuilder sb) {
        if (path != null) {
            sb.append(path);
        }
        if (query != null && !query.isEmpty()) {
            sb.append('?').append(query);
        }
        return sb.toString();
    }
}

