/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.utils.PayloadSizeLimitingHttpRequesterFilter;
import io.servicetalk.utils.internal.NumberUtils;

public final class PayloadSizeLimitingHttpServiceFilter
implements StreamingHttpServiceFilterFactory {
    private final int maxRequestPayloadSize;

    public PayloadSizeLimitingHttpServiceFilter(int maxRequestPayloadSize) {
        this.maxRequestPayloadSize = NumberUtils.ensureNonNegative((int)maxRequestPayloadSize, (String)"maxRequestPayloadSize");
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return super.handle(ctx, request.transformMessageBody(PayloadSizeLimitingHttpRequesterFilter.newLimiter(PayloadSizeLimitingHttpServiceFilter.this.maxRequestPayloadSize)), responseFactory);
            }
        };
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }
}

