/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.RedirectConfigBuilder;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.RedirectSingle;
import java.util.Objects;

public final class RedirectingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private static final RedirectConfig DEFAULT_CONFIG = new RedirectConfigBuilder().build();
    private final RedirectConfig config;

    public RedirectingHttpRequesterFilter() {
        this(DEFAULT_CONFIG);
    }

    public RedirectingHttpRequesterFilter(RedirectConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(delegate, request, RedirectingHttpRequesterFilter.this.config.allowNonRelativeRedirects());
            }

            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
                return this.delegate().reserveConnection(metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                        return RedirectingHttpRequesterFilter.this.request((StreamingHttpRequester)this.delegate(), request, false);
                    }
                });
            }
        };
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request((StreamingHttpRequester)this.delegate(), request, false);
            }
        };
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request, boolean allowNonRelativeRedirects) {
        if (this.config.maxRedirects() <= 0) {
            return delegate.request(request);
        }
        Single response = delegate.request(request.transformMessageBody(p -> p.map(item -> {
            if (item instanceof Buffer) {
                return ((Buffer)item).duplicate();
            }
            return item;
        })));
        return new RedirectSingle(delegate, request, (Single<StreamingHttpResponse>)response, allowNonRelativeRedirects, this.config);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }
}

