/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.internal.CancelImmediatelySubscriber;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

public final class BeforeFinallyHttpOperator
implements SingleOperator<StreamingHttpResponse, StreamingHttpResponse> {
    private final TerminalSignalConsumer beforeFinally;
    private final boolean discardEventsAfterCancel;

    public BeforeFinallyHttpOperator(TerminalSignalConsumer beforeFinally) {
        this(beforeFinally, false);
    }

    public BeforeFinallyHttpOperator(Runnable beforeFinally) {
        this(TerminalSignalConsumer.from((Runnable)beforeFinally));
    }

    public BeforeFinallyHttpOperator(TerminalSignalConsumer beforeFinally, boolean discardEventsAfterCancel) {
        this.beforeFinally = Objects.requireNonNull(beforeFinally);
        this.discardEventsAfterCancel = discardEventsAfterCancel;
    }

    public SingleSource.Subscriber<? super StreamingHttpResponse> apply(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
        return new ResponseCompletionSubscriber(subscriber, this.beforeFinally, this.discardEventsAfterCancel);
    }

    private static final class MessageBodySubscriber
    implements PublisherSource.Subscriber<Object> {
        private static final int PROCESSING_PAYLOAD = 0;
        private static final int DELIVERING_PAYLOAD = 1;
        private static final int AWAITING_CANCEL = 2;
        private static final int TERMINATED = -1;
        private static final AtomicIntegerFieldUpdater<MessageBodySubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(MessageBodySubscriber.class, "state");
        private final PublisherSource.Subscriber<? super Object> subscriber;
        private final TerminalSignalConsumer beforeFinally;
        private final boolean discardEventsAfterCancel;
        private volatile int state;
        @Nullable
        private PublisherSource.Subscription subscription;

        MessageBodySubscriber(PublisherSource.Subscriber<? super Object> subscriber, TerminalSignalConsumer beforeFinally, boolean discardEventsAfterCancel) {
            this.subscriber = subscriber;
            this.beforeFinally = beforeFinally;
            this.discardEventsAfterCancel = discardEventsAfterCancel;
        }

        public void onSubscribe(final PublisherSource.Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe(new PublisherSource.Subscription(){

                public void request(long n) {
                    subscription.request(n);
                }

                public void cancel() {
                    block14: {
                        int state;
                        block15: {
                            if (!discardEventsAfterCancel) {
                                try {
                                    if (stateUpdater.compareAndSet(this, 0, -1)) {
                                        beforeFinally.cancel();
                                    }
                                }
                                finally {
                                    subscription.cancel();
                                }
                                return;
                            }
                            while (true) {
                                if ((state = state) == 0) {
                                    if (!stateUpdater.compareAndSet(this, 0, -1)) continue;
                                    try {
                                        beforeFinally.cancel();
                                        break block14;
                                    }
                                    finally {
                                        subscription.cancel();
                                    }
                                }
                                if (state != 1) break block15;
                                if (stateUpdater.compareAndSet(this, 1, 2)) break;
                            }
                            break block14;
                        }
                        if (state == -1) {
                            subscription.cancel();
                        } else assert (state == 2);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(@Nullable Object o) {
            int state;
            if (!this.discardEventsAfterCancel) {
                this.subscriber.onNext(o);
                return;
            }
            boolean reentry = false;
            do {
                if ((state = this.state) == -1) {
                    return;
                }
                if (state != 1 && state != 2) continue;
                reentry = true;
                break;
            } while (!stateUpdater.compareAndSet(this, 0, 1));
            try {
                this.subscriber.onNext(o);
            }
            finally {
                block17: {
                    if (!reentry) {
                        while (true) {
                            state = this.state;
                            assert (state != 0);
                            if (state == -1) break block17;
                            if (state == 1) {
                                if (!stateUpdater.compareAndSet(this, 1, 0)) continue;
                                break block17;
                            }
                            if (stateUpdater.compareAndSet(this, 2, -1)) break;
                        }
                        try {
                            this.beforeFinally.cancel();
                        }
                        finally {
                            assert (this.subscription != null);
                            this.subscription.cancel();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            if (!this.discardEventsAfterCancel) {
                try {
                    if (stateUpdater.compareAndSet(this, 0, -1)) {
                        this.beforeFinally.onError(t);
                    }
                }
                catch (Throwable cause) {
                    ThrowableUtils.addSuppressed((Throwable)t, (Throwable)cause);
                }
                this.subscriber.onError(t);
                return;
            }
            int prevState = this.setTerminalState();
            if (prevState == -1) {
                return;
            }
            boolean propagateCancel = prevState == 2;
            try {
                this.beforeFinally.onError(t);
            }
            catch (Throwable cause) {
                ThrowableUtils.addSuppressed((Throwable)t, (Throwable)cause);
            }
            try {
                this.subscriber.onError(t);
            }
            finally {
                this.cancel0(propagateCancel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (!this.discardEventsAfterCancel) {
                try {
                    if (stateUpdater.compareAndSet(this, 0, -1)) {
                        this.beforeFinally.onComplete();
                    }
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onComplete();
                return;
            }
            int prevState = this.setTerminalState();
            if (prevState == -1) {
                return;
            }
            boolean propagateCancel = prevState == 2;
            try {
                try {
                    this.beforeFinally.onComplete();
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    this.cancel0(propagateCancel);
                    return;
                }
                this.subscriber.onComplete();
            }
            finally {
                this.cancel0(propagateCancel);
            }
        }

        private int setTerminalState() {
            return stateUpdater.getAndSet(this, -1);
        }

        private void cancel0(boolean propagateCancel) {
            if (propagateCancel) {
                assert (this.subscription != null);
                this.subscription.cancel();
            }
        }
    }

    private static final class ResponseCompletionSubscriber
    implements SingleSource.Subscriber<StreamingHttpResponse> {
        private static final int IDLE = 0;
        private static final int PROCESSING_PAYLOAD = 1;
        private static final int RESPONSE_COMPLETE = -1;
        private static final AtomicIntegerFieldUpdater<ResponseCompletionSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ResponseCompletionSubscriber.class, "state");
        private static final SingleSource.Subscriber<StreamingHttpResponse> NOOP_SUBSCRIBER = new SingleSource.Subscriber<StreamingHttpResponse>(){

            public void onSubscribe(Cancellable cancellable) {
            }

            public void onSuccess(@Nullable StreamingHttpResponse result) {
            }

            public void onError(Throwable t) {
            }
        };
        private SingleSource.Subscriber<? super StreamingHttpResponse> subscriber;
        private final TerminalSignalConsumer beforeFinally;
        private final boolean discardEventsAfterCancel;
        private volatile int state;

        ResponseCompletionSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> sub, TerminalSignalConsumer beforeFinally, boolean discardEventsAfterCancel) {
            this.subscriber = sub;
            this.beforeFinally = beforeFinally;
            this.discardEventsAfterCancel = discardEventsAfterCancel;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(() -> {
                try {
                    int previous = stateUpdater.getAndSet(this, -1);
                    if (previous == 0 || previous == 1) {
                        this.beforeFinally.cancel();
                    }
                }
                finally {
                    cancellable.cancel();
                }
            });
        }

        public void onSuccess(@Nullable StreamingHttpResponse response) {
            if (response == null) {
                this.sendNullResponse();
            } else if (stateUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onSuccess((Object)response.transformMessageBody(payload -> payload.liftSync(messageBodySubscriber -> stateUpdater.compareAndSet(this, 1, -1) ? new MessageBodySubscriber((PublisherSource.Subscriber<? super Object>)messageBodySubscriber, this.beforeFinally, this.discardEventsAfterCancel) : messageBodySubscriber)));
            } else {
                assert (this.state == -1);
                SourceAdapters.toSource((Publisher)response.messageBody()).subscribe((PublisherSource.Subscriber)CancelImmediatelySubscriber.INSTANCE);
                if (!this.discardEventsAfterCancel) {
                    this.subscriber.onSuccess((Object)response.transformMessageBody(payload -> Publisher.defer(() -> Publisher.failed((Throwable)new CancellationException("Received response post cancel")))));
                }
            }
            this.dereferenceSubscriber();
        }

        public void onError(Throwable t) {
            try {
                if (stateUpdater.compareAndSet(this, 0, -1)) {
                    this.beforeFinally.onError(t);
                } else if (this.discardEventsAfterCancel) {
                    return;
                }
            }
            catch (Throwable cause) {
                ThrowableUtils.addSuppressed((Throwable)t, (Throwable)cause);
            }
            this.subscriber.onError(t);
            this.dereferenceSubscriber();
        }

        private void sendNullResponse() {
            try {
                if (stateUpdater.compareAndSet(this, 0, -1)) {
                    this.beforeFinally.onComplete();
                } else if (this.discardEventsAfterCancel) {
                    return;
                }
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                this.dereferenceSubscriber();
                return;
            }
            this.subscriber.onSuccess(null);
            this.dereferenceSubscriber();
        }

        private void dereferenceSubscriber() {
            this.subscriber = NOOP_SUBSCRIBER;
        }
    }
}

