/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.utils.internal.NetworkUtils;

public final class HostHeaderHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private final CharSequence fallbackHost;

    public HostHeaderHttpRequesterFilter(CharSequence fallbackHost) {
        this.fallbackHost = CharSequences.newAsciiString((CharSequence)(NetworkUtils.isValidIpV6Address((CharSequence)fallbackHost) && fallbackHost.charAt(0) != '[' ? "[" + fallbackHost + "]" : fallbackHost.toString()));
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return HostHeaderHttpRequesterFilter.this.request(delegate, request);
            }
        };
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return HostHeaderHttpRequesterFilter.this.request((StreamingHttpRequester)this.delegate(), request);
            }
        };
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
        return Single.defer(() -> {
            if (!HttpProtocolVersion.HTTP_1_0.equals((Object)request.version()) && !request.headers().contains(HttpHeaderNames.HOST)) {
                this.setRequestHeader((HttpRequestMetaData)request);
            }
            return delegate.request(request).shareContextOnSubscribe();
        });
    }

    private void setRequestHeader(HttpRequestMetaData metaData) {
        CharSequence authority = metaData.host();
        if (authority == null) {
            authority = this.fallbackHost;
        } else {
            int port = metaData.port();
            if (port >= 0) {
                authority = authority + ":" + port;
            }
        }
        metaData.headers().add(HttpHeaderNames.HOST, authority);
    }
}

