/*
 * Copyright © 2020 Apple Inc. and the ServiceTalk project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicetalk.logging.api;

/**
 * Defines different severity level of logging.
 */
public enum LogLevel {
    /**
     * {@code TRACE} log level.
     */
    TRACE,
    /**
     * {@code DEBUG} log level.
     */
    DEBUG,
    /**
     * {@code INFO} log level.
     */
    INFO,
    /**
     * {@code WARN} log level.
     */
    WARN,
    /**
     * {@code ERROR} log level.
     */
    ERROR
}
