/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.http;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import io.servicetalk.opentracing.http.TracingHttpHeadersFormatter;
import io.servicetalk.opentracing.inmemory.api.InMemoryTraceStateFormat;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractTracingHttpFilter {
    protected final Tracer tracer;
    protected final String componentName;
    protected final InMemoryTraceStateFormat<HttpHeaders> formatter;

    AbstractTracingHttpFilter(Tracer tracer, String componentName, boolean validateTraceKeyFormat) {
        this.tracer = Objects.requireNonNull(tracer);
        this.componentName = Objects.requireNonNull(componentName);
        this.formatter = TracingHttpHeadersFormatter.traceStateFormatter(validateTraceKeyFormat);
    }

    static class ScopeTracker
    implements TerminalSignalConsumer {
        private final Scope currentScope;
        private final Span span;
        @Nullable
        private HttpResponseMetaData metaData;

        ScopeTracker(Scope currentScope, Span span) {
            this.currentScope = Objects.requireNonNull(currentScope);
            this.span = Objects.requireNonNull(span);
        }

        void onResponseMeta(HttpResponseMetaData metaData) {
            this.metaData = metaData;
        }

        public void onComplete() {
            assert (this.metaData != null) : "can't have succeeded without capturing metadata first";
            this.tagStatusCode();
            try {
                if (this.isError(this.metaData)) {
                    Tags.ERROR.set(this.span, Boolean.valueOf(true));
                }
            }
            finally {
                this.closeAll();
            }
        }

        public void onError(Throwable throwable) {
            try {
                this.tagStatusCode();
                Tags.ERROR.set(this.span, Boolean.valueOf(true));
            }
            finally {
                this.closeAll();
            }
        }

        public void cancel() {
            try {
                this.tagStatusCode();
                Tags.ERROR.set(this.span, Boolean.valueOf(true));
            }
            finally {
                this.closeAll();
            }
        }

        protected boolean isError(HttpResponseMetaData metaData) {
            return metaData.status().statusClass().equals((Object)HttpResponseStatus.StatusClass.SERVER_ERROR_5XX);
        }

        Single<StreamingHttpResponse> track(Single<StreamingHttpResponse> responseSingle) {
            return responseSingle.liftSync((SingleOperator)new BeforeFinallyHttpOperator((TerminalSignalConsumer)this)).beforeOnSuccess(this::onResponseMeta);
        }

        private void tagStatusCode() {
            if (this.metaData != null) {
                Tags.HTTP_STATUS.set(this.span, Integer.valueOf(this.metaData.status().code()));
            }
        }

        private void closeAll() {
            try {
                this.currentScope.close();
            }
            finally {
                this.span.finish();
            }
        }

        final Span getSpan() {
            return this.span;
        }
    }
}

