/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.http;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.opentracing.inmemory.DefaultInMemoryTraceState;
import io.servicetalk.opentracing.inmemory.api.InMemoryTraceState;
import io.servicetalk.opentracing.inmemory.api.InMemoryTraceStateFormat;
import io.servicetalk.opentracing.internal.HexUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracingHttpHeadersFormatter
implements InMemoryTraceStateFormat<HttpHeaders> {
    private static final Logger logger = LoggerFactory.getLogger(TracingHttpHeadersFormatter.class);
    private static final CharSequence TRACE_ID = CharSequences.newAsciiString((String)"x-b3-traceid");
    private static final CharSequence SPAN_ID = CharSequences.newAsciiString((String)"x-b3-spanid");
    private static final CharSequence PARENT_SPAN_ID = CharSequences.newAsciiString((String)"x-b3-parentspanid");
    private static final CharSequence SAMPLED = CharSequences.newAsciiString((String)"x-b3-sampled");
    static final InMemoryTraceStateFormat<HttpHeaders> FORMATTER_VALIDATION = new TracingHttpHeadersFormatter(true);
    static final InMemoryTraceStateFormat<HttpHeaders> FORMATTER_NO_VALIDATION = new TracingHttpHeadersFormatter(false);
    private final boolean verifyExtractedValues;

    private TracingHttpHeadersFormatter(boolean verifyExtractedValues) {
        this.verifyExtractedValues = verifyExtractedValues;
    }

    static InMemoryTraceStateFormat<HttpHeaders> traceStateFormatter(boolean validateTraceKeyFormat) {
        return validateTraceKeyFormat ? FORMATTER_VALIDATION : FORMATTER_NO_VALIDATION;
    }

    public void inject(InMemoryTraceState state, HttpHeaders carrier) {
        carrier.set(TRACE_ID, (CharSequence)state.traceIdHex());
        carrier.set(SPAN_ID, (CharSequence)state.spanIdHex());
        String parentSpanIdHex = state.parentSpanIdHex();
        if (parentSpanIdHex != null) {
            carrier.set(PARENT_SPAN_ID, (CharSequence)parentSpanIdHex);
        }
        carrier.set(SAMPLED, (CharSequence)(state.isSampled() ? "1" : "0"));
    }

    @Nullable
    public InMemoryTraceState extract(HttpHeaders carrier) {
        CharSequence traceId = carrier.get(TRACE_ID);
        if (traceId == null) {
            return null;
        }
        CharSequence spanId = carrier.get(SPAN_ID);
        if (spanId == null) {
            return null;
        }
        CharSequence parentSpanId = carrier.get(PARENT_SPAN_ID);
        if (this.verifyExtractedValues) {
            HexUtils.validateHexBytes((CharSequence)traceId);
            HexUtils.validateHexBytes((CharSequence)spanId);
            if (parentSpanId != null) {
                HexUtils.validateHexBytes((CharSequence)parentSpanId);
                if (CharSequences.contentEqualsIgnoreCase((CharSequence)parentSpanId, (CharSequence)spanId)) {
                    logger.warn("SpanId cannot be the same as ParentSpanId, value={}", (Object)parentSpanId);
                    return null;
                }
            }
        }
        CharSequence sampleId = carrier.get(SAMPLED);
        return new DefaultInMemoryTraceState(traceId.toString(), spanId.toString(), String.valueOf(parentSpanId), sampleId != null && sampleId.length() == 1 && sampleId.charAt(0) != '0');
    }
}

