/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.http;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.opentracing.http.AbstractTracingHttpFilter;

public class TracingHttpRequesterFilter
extends AbstractTracingHttpFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    public TracingHttpRequesterFilter(Tracer tracer, String componentName) {
        this(tracer, componentName, true);
    }

    public TracingHttpRequesterFilter(Tracer tracer, String componentName, boolean validateTraceKeyFormat) {
        super(tracer, componentName, validateTraceKeyFormat);
    }

    public final StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return Single.defer(() -> TracingHttpRequesterFilter.this.trackRequest(delegate, strategy, request).subscribeShareContext());
            }
        };
    }

    public final StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return Single.defer(() -> TracingHttpRequesterFilter.this.trackRequest((StreamingHttpRequester)this.delegate(), strategy, request).subscribeShareContext());
            }
        };
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }

    private Single<StreamingHttpResponse> trackRequest(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        Single response;
        AbstractTracingHttpFilter.ScopeTracker tracker = this.newTracker((HttpRequestMetaData)request);
        try {
            response = delegate.request(strategy, request);
        }
        catch (Throwable t) {
            tracker.onError(t);
            return Single.failed((Throwable)t);
        }
        return tracker.track((Single<StreamingHttpResponse>)response);
    }

    private AbstractTracingHttpFilter.ScopeTracker newTracker(HttpRequestMetaData request) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(this.componentName).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_METHOD.getKey(), request.method().name()).withTag(Tags.HTTP_URL.getKey(), request.path());
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan != null) {
            spanBuilder = spanBuilder.asChildOf(activeSpan);
        }
        Span span = spanBuilder.start();
        Scope scope = this.tracer.activateSpan(span);
        try {
            this.tracer.inject(span.context(), (Format)this.formatter, (Object)request.headers());
            return new AbstractTracingHttpFilter.ScopeTracker(scope, span);
        }
        catch (Throwable cause) {
            TracingHttpRequesterFilter.handlePrematureError(span, scope);
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePrematureError(Span span, Scope scope) {
        try {
            scope.close();
        }
        finally {
            try {
                Tags.ERROR.set(span, Boolean.valueOf(true));
            }
            finally {
                span.finish();
            }
        }
    }
}

