/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.http;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.opentracing.http.AbstractTracingHttpFilter;
import javax.annotation.Nullable;

public class TracingHttpServiceFilter
extends AbstractTracingHttpFilter
implements StreamingHttpServiceFilterFactory {
    public TracingHttpServiceFilter(Tracer tracer, String componentName) {
        this(tracer, componentName, true);
    }

    public TracingHttpServiceFilter(Tracer tracer, String componentName, boolean validateTraceKeyFormat) {
        super(tracer, componentName, validateTraceKeyFormat);
    }

    public TracingHttpServiceFilter(Tracer tracer, String componentName, Format<HttpHeaders> format) {
        super(tracer, componentName, format);
    }

    public TracingHttpServiceFilter(Tracer tracer, Format<TextMap> format, String componentName) {
        super(tracer, format, componentName);
    }

    public final StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return TracingHttpServiceFilter.this.trackRequest(this.delegate(), ctx, request, responseFactory);
            }
        };
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> trackRequest(StreamingHttpService delegate, HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
        Single response;
        AbstractTracingHttpFilter.ScopeTracker tracker = this.newTracker(request);
        try {
            response = delegate.handle(ctx, request, responseFactory);
        }
        catch (Throwable t) {
            tracker.onError(t);
            return Single.failed((Throwable)t);
        }
        return tracker.track((Single<StreamingHttpResponse>)response);
    }

    private AbstractTracingHttpFilter.ScopeTracker newTracker(StreamingHttpRequest request) {
        SpanContext parentSpanContext = (SpanContext)this.extractor.apply(request.headers());
        Span span = this.tracer.buildSpan(this.getOperationName(this.componentName, (HttpRequestMetaData)request)).asChildOf(parentSpanContext).withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.HTTP_METHOD.getKey(), request.method().name()).withTag(Tags.HTTP_URL.getKey(), request.path()).start();
        Scope scope = this.tracer.activateSpan(span);
        return new ServiceScopeTracker(scope, span, parentSpanContext);
    }

    protected String getOperationName(String componentName, HttpRequestMetaData metaData) {
        return componentName + ' ' + metaData.method().name() + ' ' + metaData.requestTarget();
    }

    protected boolean injectSpanContextIntoResponse(@Nullable SpanContext parentSpanContext) {
        return parentSpanContext == null;
    }

    private final class ServiceScopeTracker
    extends AbstractTracingHttpFilter.ScopeTracker {
        @Nullable
        private final SpanContext parentSpanContext;

        ServiceScopeTracker(Scope scope, @Nullable Span span, SpanContext parentSpanContext) {
            super(scope, span);
            this.parentSpanContext = parentSpanContext;
        }

        @Override
        void onResponseMeta(HttpResponseMetaData metaData) {
            super.onResponseMeta(metaData);
            if (TracingHttpServiceFilter.this.injectSpanContextIntoResponse(this.parentSpanContext)) {
                TracingHttpServiceFilter.this.injector.accept(this.getSpan().context(), metaData.headers());
            }
        }
    }
}

