/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.http;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import io.servicetalk.opentracing.inmemory.B3KeyValueFormatter;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractTracingHttpFilter {
    final Tracer tracer;
    final String componentName;
    final BiConsumer<SpanContext, HttpHeaders> injector;
    final Function<HttpHeaders, SpanContext> extractor;

    AbstractTracingHttpFilter(Tracer tracer, String componentName, boolean validateTraceKeyFormat) {
        this(tracer, componentName, (Format<HttpHeaders>)HttpHeadersB3KeyValueFormatter.traceStateFormatter(validateTraceKeyFormat));
    }

    AbstractTracingHttpFilter(Tracer tracer, String componentName, Format<HttpHeaders> format) {
        Objects.requireNonNull(format);
        this.tracer = Objects.requireNonNull(tracer);
        this.componentName = Objects.requireNonNull(componentName);
        this.injector = (spanContext, headers) -> tracer.inject(spanContext, format, headers);
        this.extractor = headers -> tracer.extract(format, headers);
    }

    AbstractTracingHttpFilter(Tracer tracer, Format<TextMap> format, String componentName) {
        Objects.requireNonNull(format);
        this.tracer = Objects.requireNonNull(tracer);
        this.componentName = Objects.requireNonNull(componentName);
        this.injector = (spanContext, headers) -> tracer.inject(spanContext, format, (Object)new HttpHeadersToTextMap((HttpHeaders)headers));
        this.extractor = headers -> tracer.extract(format, (Object)new HttpHeadersToTextMap((HttpHeaders)headers));
    }

    private static final class HttpHeadersToTextMap
    implements TextMap {
        private final HttpHeaders headers;

        private HttpHeadersToTextMap(HttpHeaders headers) {
            this.headers = Objects.requireNonNull(headers);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                private final Iterator<Map.Entry<CharSequence, CharSequence>> itr;
                {
                    this.itr = headers.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.itr.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new Map.Entry<String, String>(){
                        private final Map.Entry<CharSequence, CharSequence> next;
                        {
                            this.next = (Map.Entry)itr.next();
                        }

                        @Override
                        public String getKey() {
                            return Objects.toString(this.next.getKey());
                        }

                        @Override
                        public String getValue() {
                            return Objects.toString(this.next.getValue());
                        }

                        @Override
                        public String setValue(String value) {
                            return Objects.toString(this.next.setValue(value));
                        }
                    };
                }

                @Override
                public void remove() {
                    this.itr.remove();
                }
            };
        }

        public void put(String s, String s1) {
            this.headers.set((CharSequence)s, (CharSequence)s1);
        }
    }

    static class ScopeTracker
    implements TerminalSignalConsumer {
        private final Scope currentScope;
        private final Span span;
        @Nullable
        private HttpResponseMetaData metaData;

        ScopeTracker(Scope currentScope, Span span) {
            this.currentScope = Objects.requireNonNull(currentScope);
            this.span = Objects.requireNonNull(span);
        }

        void onResponseMeta(HttpResponseMetaData metaData) {
            this.metaData = metaData;
        }

        public void onComplete() {
            assert (this.metaData != null) : "can't have succeeded without capturing metadata first";
            this.tagStatusCode();
            try {
                if (this.isError(this.metaData)) {
                    Tags.ERROR.set(this.span, Boolean.valueOf(true));
                }
            }
            finally {
                this.closeAll();
            }
        }

        public void onError(Throwable throwable) {
            try {
                this.tagStatusCode();
                Tags.ERROR.set(this.span, Boolean.valueOf(true));
            }
            finally {
                this.closeAll();
            }
        }

        public void cancel() {
            try {
                this.tagStatusCode();
                Tags.ERROR.set(this.span, Boolean.valueOf(true));
            }
            finally {
                this.closeAll();
            }
        }

        protected boolean isError(HttpResponseMetaData metaData) {
            return metaData.status().statusClass().equals((Object)HttpResponseStatus.StatusClass.SERVER_ERROR_5XX);
        }

        Single<StreamingHttpResponse> track(Single<StreamingHttpResponse> responseSingle) {
            return responseSingle.liftSync((SingleOperator)new BeforeFinallyHttpOperator((TerminalSignalConsumer)this)).beforeOnSuccess(this::onResponseMeta);
        }

        private void tagStatusCode() {
            if (this.metaData != null) {
                Tags.HTTP_STATUS.set(this.span, Integer.valueOf(this.metaData.status().code()));
            }
        }

        private void closeAll() {
            try {
                this.currentScope.close();
            }
            finally {
                this.span.finish();
            }
        }

        final Span getSpan() {
            return this.span;
        }
    }

    static final class HttpHeadersB3KeyValueFormatter
    extends B3KeyValueFormatter<HttpHeaders> {
        private static final InMemorySpanContextFormat<HttpHeaders> FORMATTER_VALIDATION = new HttpHeadersB3KeyValueFormatter(true);
        private static final InMemorySpanContextFormat<HttpHeaders> FORMATTER_NO_VALIDATION = new HttpHeadersB3KeyValueFormatter(false);

        HttpHeadersB3KeyValueFormatter(boolean verifyExtractedValues) {
            super(HttpHeaders::set, HttpHeaders::get, verifyExtractedValues);
        }

        static InMemorySpanContextFormat<HttpHeaders> traceStateFormatter(boolean validateTraceKeyFormat) {
            return validateTraceKeyFormat ? FORMATTER_VALIDATION : FORMATTER_NO_VALIDATION;
        }
    }
}

