/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.Span;
import io.servicetalk.opentracing.inmemory.api.InMemoryReference;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInMemorySpan
implements InMemorySpan {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInMemorySpan.class);
    private final InMemorySpanContext context;
    private final List<InMemoryReference> references;
    String operationName;

    AbstractInMemorySpan(String operationName, List<InMemoryReference> references, InMemorySpanContext context) {
        this.context = Objects.requireNonNull(context);
        this.operationName = operationName;
        this.references = references;
    }

    public final InMemorySpanContext context() {
        return this.context;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final List<InMemoryReference> references() {
        return Collections.unmodifiableList(this.references);
    }

    public final Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public final Span setBaggageItem(String key, String value) {
        logger.debug("setBaggageItem() is not supported");
        return this;
    }

    @Nullable
    public final String getBaggageItem(String key) {
        logger.debug("getBaggageItem() is not supported");
        return null;
    }
}

