/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.servicetalk.opentracing.inmemory.DefaultInMemoryReference;
import io.servicetalk.opentracing.inmemory.api.InMemoryReference;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanBuilder;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInMemorySpanBuilder
implements InMemorySpanBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInMemorySpanBuilder.class);
    private final String operationName;
    private final List<InMemoryReference> references = new ArrayList<InMemoryReference>(2);
    private final Map<String, Object> tags = new HashMap<String, Object>(4);
    private final int maxTagSize;
    private long startTimestampMicros = -1L;
    private boolean ignoreActiveSpan;

    AbstractInMemorySpanBuilder(String operationName, int maxTagSize) {
        this.operationName = Objects.requireNonNull(operationName);
        this.maxTagSize = maxTagSize;
    }

    public final InMemorySpanBuilder asChildOf(@Nullable SpanContext parent) {
        if (parent != null) {
            this.addReference("child_of", parent);
        }
        return this;
    }

    public final InMemorySpanBuilder asChildOf(@Nullable Span parent) {
        if (parent != null) {
            this.addReference("child_of", parent.context());
        }
        return this;
    }

    public final InMemorySpanBuilder addReference(String referenceType, InMemorySpanContext referencedContext) {
        this.references.add(new DefaultInMemoryReference(referenceType, referencedContext));
        return this;
    }

    public final InMemorySpanBuilder withTag(String key, String value) {
        this.putTag(key, value);
        return this;
    }

    public final InMemorySpanBuilder withTag(String key, boolean value) {
        this.putTag(key, value);
        return this;
    }

    public final InMemorySpanBuilder withTag(String key, Number value) {
        this.putTag(key, value);
        return this;
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        this.putTag(tag.getKey(), value);
        return this;
    }

    public final InMemorySpanBuilder withStartTimestamp(long microseconds) {
        this.startTimestampMicros = microseconds;
        return this;
    }

    public final InMemorySpan start() {
        if (this.startTimestampMicros == -1L) {
            this.startTimestampMicros = System.currentTimeMillis() * 1000L;
        }
        return this.createSpan(this.operationName, this.references, this.tags, this.maxTagSize, this.ignoreActiveSpan, this.startTimestampMicros);
    }

    @Nullable
    protected final InMemorySpanContext parent() {
        for (int i = 0; i < this.references.size(); ++i) {
            InMemoryReference reference = this.references.get(i);
            if (!"child_of".equals(reference.type()) && !"follows_from".equals(reference.type())) continue;
            return reference.referredTo();
        }
        return null;
    }

    private void putTag(String key, Object value) {
        if (this.tags.size() < this.maxTagSize) {
            this.tags.put(key, value);
        } else {
            logger.warn("Tag {} ignored since maxTagSize={} is reached", (Object)key, (Object)this.maxTagSize);
        }
    }

    public InMemorySpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    abstract InMemorySpan createSpan(String var1, List<InMemoryReference> var2, Map<String, Object> var3, int var4, boolean var5, long var6);
}

