/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import io.servicetalk.opentracing.inmemory.TextMapFormatter;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextExtractor;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextInjector;
import io.servicetalk.opentracing.inmemory.api.InMemoryTracer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInMemoryTracer
implements InMemoryTracer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInMemoryTracer.class);

    AbstractInMemoryTracer() {
    }

    public final <C> void inject(InMemorySpanContext spanContext, Format<C> format, C carrier) {
        block4: {
            try {
                if (format instanceof InMemorySpanContextInjector) {
                    InMemorySpanContextInjector injector = (InMemorySpanContextInjector)format;
                    injector.inject(spanContext, carrier);
                    break block4;
                }
                if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_INJECT || format == Format.Builtin.HTTP_HEADERS) {
                    TextMapFormatter.INSTANCE.inject(spanContext, (TextMapInject)carrier);
                    break block4;
                }
                throw new UnsupportedOperationException("Format " + format + " is not supported");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to inject SpanContext into carrier", (Throwable)e);
            }
        }
    }

    @Nullable
    public final <C> InMemorySpanContext extract(Format<C> format, C carrier) {
        try {
            if (format instanceof InMemorySpanContextExtractor) {
                InMemorySpanContextExtractor extractor = (InMemorySpanContextExtractor)format;
                return extractor.extract(carrier);
            }
            if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_EXTRACT || format == Format.Builtin.HTTP_HEADERS) {
                return TextMapFormatter.INSTANCE.extract((TextMapExtract)carrier);
            }
            throw new UnsupportedOperationException("Format " + format + " is not supported");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to inject SpanContext into carrier", (Throwable)e);
            return null;
        }
    }
}

