/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.TriConsumer;
import io.servicetalk.opentracing.inmemory.DefaultInMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextFormat;
import io.servicetalk.opentracing.internal.HexUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class B3KeyValueFormatter<T>
implements InMemorySpanContextFormat<T> {
    private final TriConsumer<T, CharSequence, CharSequence> carrierInjector;
    private final BiFunction<T, CharSequence, CharSequence> carrierExtractor;
    private static final Logger logger = LoggerFactory.getLogger(B3KeyValueFormatter.class);
    private static final CharSequence TRACE_ID = CharSequences.newAsciiString((CharSequence)"x-b3-traceid");
    private static final CharSequence SPAN_ID = CharSequences.newAsciiString((CharSequence)"x-b3-spanid");
    private static final CharSequence PARENT_SPAN_ID = CharSequences.newAsciiString((CharSequence)"x-b3-parentspanid");
    private static final CharSequence SAMPLED = CharSequences.newAsciiString((CharSequence)"x-b3-sampled");
    private final boolean verifyExtractedValues;

    public B3KeyValueFormatter(TriConsumer<T, CharSequence, CharSequence> carrierInjector, BiFunction<T, CharSequence, CharSequence> carrierExtractor, boolean verifyExtractedValues) {
        this.carrierInjector = Objects.requireNonNull(carrierInjector);
        this.carrierExtractor = Objects.requireNonNull(carrierExtractor);
        this.verifyExtractedValues = verifyExtractedValues;
    }

    public void inject(InMemorySpanContext context, T carrier) {
        Boolean isSampled;
        this.carrierInjector.accept(carrier, (Object)TRACE_ID, (Object)context.toTraceId());
        this.carrierInjector.accept(carrier, (Object)SPAN_ID, (Object)context.toSpanId());
        String parentSpanIdHex = context.parentSpanId();
        if (parentSpanIdHex != null) {
            this.carrierInjector.accept(carrier, (Object)PARENT_SPAN_ID, (Object)parentSpanIdHex);
        }
        if ((isSampled = context.isSampled()) != null) {
            this.carrierInjector.accept(carrier, (Object)SAMPLED, (Object)(isSampled != false ? "1" : "0"));
        }
    }

    @Nullable
    public InMemorySpanContext extract(T carrier) {
        CharSequence traceId = this.carrierExtractor.apply(carrier, TRACE_ID);
        if (traceId == null) {
            return null;
        }
        CharSequence spanId = this.carrierExtractor.apply(carrier, SPAN_ID);
        if (spanId == null) {
            return null;
        }
        CharSequence parentSpanId = this.carrierExtractor.apply(carrier, PARENT_SPAN_ID);
        if (this.verifyExtractedValues) {
            HexUtils.validateHexBytes((CharSequence)traceId);
            HexUtils.validateHexBytes((CharSequence)spanId);
            if (parentSpanId != null) {
                HexUtils.validateHexBytes((CharSequence)parentSpanId);
                if (CharSequences.contentEqualsIgnoreCase((CharSequence)parentSpanId, (CharSequence)spanId)) {
                    logger.warn("SpanId cannot be the same as ParentSpanId, value={}", (Object)parentSpanId);
                    return null;
                }
            }
        }
        CharSequence sampleId = this.carrierExtractor.apply(carrier, SAMPLED);
        return new DefaultInMemorySpanContext(traceId.toString(), spanId.toString(), String.valueOf(parentSpanId), sampleId != null ? Boolean.valueOf(sampleId.length() == 1 && sampleId.charAt(0) != '0') : null);
    }
}

