/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanEventListener;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class CopyOnWriteInMemorySpanEventListenerSet
implements InMemorySpanEventListener {
    private static final AtomicReferenceFieldUpdater<CopyOnWriteInMemorySpanEventListenerSet, CopyOnWriteSet> setUpdater = AtomicReferenceFieldUpdater.newUpdater(CopyOnWriteInMemorySpanEventListenerSet.class, CopyOnWriteSet.class, "set");
    private volatile CopyOnWriteSet set = EmptyCopyOnWriteSet.INSTANCE;

    CopyOnWriteInMemorySpanEventListenerSet() {
    }

    boolean add(InMemorySpanEventListener listener) {
        CopyOnWriteSet newSet;
        CopyOnWriteSet set;
        do {
            if ((newSet = (set = this.set).add(listener)) != set) continue;
            return false;
        } while (!setUpdater.compareAndSet(this, set, newSet));
        return true;
    }

    boolean remove(InMemorySpanEventListener listener) {
        CopyOnWriteSet newSet;
        CopyOnWriteSet set;
        do {
            if ((newSet = (set = this.set).remove(listener)) != set) continue;
            return false;
        } while (!setUpdater.compareAndSet(this, set, newSet));
        return true;
    }

    public void onSpanStarted(InMemorySpan span) {
        this.set.onSpanStarted(span);
    }

    public void onEventLogged(InMemorySpan span, long epochMicros, String eventName) {
        this.set.onEventLogged(span, epochMicros, eventName);
    }

    public void onEventLogged(InMemorySpan span, long epochMicros, Map<String, ?> payload) {
        this.set.onEventLogged(span, epochMicros, payload);
    }

    public void onSpanFinished(InMemorySpan span, long durationMicros) {
        this.set.onSpanFinished(span, durationMicros);
    }

    private static final class ThreeOrMoreCopyOnWriteSet
    implements CopyOnWriteSet {
        private final InMemorySpanEventListener[] listeners;

        ThreeOrMoreCopyOnWriteSet(InMemorySpanEventListener ... listeners) {
            this.listeners = listeners;
        }

        @Override
        public CopyOnWriteSet add(InMemorySpanEventListener listener) {
            Objects.requireNonNull(listener);
            for (InMemorySpanEventListener listener1 : this.listeners) {
                if (!listener1.equals(listener)) continue;
                return this;
            }
            InMemorySpanEventListener[] newListeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
            newListeners[this.listeners.length] = listener;
            return new ThreeOrMoreCopyOnWriteSet(newListeners);
        }

        @Override
        public CopyOnWriteSet remove(InMemorySpanEventListener listener) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (!this.listeners[i].equals(listener)) continue;
                if (this.listeners.length == 3) {
                    switch (i) {
                        case 0: {
                            return new TwoCopyOnWriteSet(this.listeners[1], this.listeners[2]);
                        }
                        case 1: {
                            return new TwoCopyOnWriteSet(this.listeners[0], this.listeners[2]);
                        }
                    }
                    return new TwoCopyOnWriteSet(this.listeners[0], this.listeners[1]);
                }
                InMemorySpanEventListener[] newListeners = new InMemorySpanEventListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, i);
                if (i < newListeners.length) {
                    System.arraycopy(this.listeners, i + 1, newListeners, i, newListeners.length - i);
                }
                return new ThreeOrMoreCopyOnWriteSet(newListeners);
            }
            return this;
        }

        public void onSpanStarted(InMemorySpan span) {
            for (InMemorySpanEventListener listener : this.listeners) {
                listener.onSpanStarted(span);
            }
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, String eventName) {
            for (InMemorySpanEventListener listener : this.listeners) {
                listener.onEventLogged(span, epochMicros, eventName);
            }
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, Map<String, ?> fields) {
            for (InMemorySpanEventListener listener : this.listeners) {
                listener.onEventLogged(span, epochMicros, fields);
            }
        }

        public void onSpanFinished(InMemorySpan span, long durationMicros) {
            for (InMemorySpanEventListener listener : this.listeners) {
                listener.onSpanFinished(span, durationMicros);
            }
        }
    }

    private static final class TwoCopyOnWriteSet
    implements CopyOnWriteSet {
        private final InMemorySpanEventListener first;
        private final InMemorySpanEventListener second;

        TwoCopyOnWriteSet(InMemorySpanEventListener first, InMemorySpanEventListener second) {
            this.first = first;
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public CopyOnWriteSet add(InMemorySpanEventListener listener) {
            return this.first.equals(listener) || this.second.equals(listener) ? this : new ThreeOrMoreCopyOnWriteSet(this.first, this.second, Objects.requireNonNull(listener));
        }

        @Override
        public CopyOnWriteSet remove(InMemorySpanEventListener listener) {
            if (this.first.equals(listener)) {
                return new OneCopyOnWriteSet(this.second);
            }
            if (this.second.equals(listener)) {
                return new OneCopyOnWriteSet(this.first);
            }
            return this;
        }

        public void onSpanStarted(InMemorySpan span) {
            this.first.onSpanStarted(span);
            this.second.onSpanStarted(span);
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, String eventName) {
            this.first.onEventLogged(span, epochMicros, eventName);
            this.second.onEventLogged(span, epochMicros, eventName);
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, Map<String, ?> fields) {
            this.first.onEventLogged(span, epochMicros, fields);
            this.second.onEventLogged(span, epochMicros, fields);
        }

        public void onSpanFinished(InMemorySpan span, long durationMicros) {
            this.first.onSpanFinished(span, durationMicros);
            this.second.onSpanFinished(span, durationMicros);
        }
    }

    private static final class OneCopyOnWriteSet
    implements CopyOnWriteSet {
        private final InMemorySpanEventListener listener;

        OneCopyOnWriteSet(InMemorySpanEventListener listener) {
            this.listener = Objects.requireNonNull(listener);
        }

        @Override
        public CopyOnWriteSet add(InMemorySpanEventListener listener) {
            return this.listener.equals(listener) ? this : new TwoCopyOnWriteSet(this.listener, listener);
        }

        @Override
        public CopyOnWriteSet remove(InMemorySpanEventListener listener) {
            return this.listener.equals(listener) ? EmptyCopyOnWriteSet.INSTANCE : this;
        }

        public void onSpanStarted(InMemorySpan span) {
            this.listener.onSpanStarted(span);
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, String eventName) {
            this.listener.onEventLogged(span, epochMicros, eventName);
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, Map<String, ?> fields) {
            this.listener.onEventLogged(span, epochMicros, fields);
        }

        public void onSpanFinished(InMemorySpan span, long durationMicros) {
            this.listener.onSpanFinished(span, durationMicros);
        }
    }

    private static final class EmptyCopyOnWriteSet
    implements CopyOnWriteSet {
        static final CopyOnWriteSet INSTANCE = new EmptyCopyOnWriteSet();

        private EmptyCopyOnWriteSet() {
        }

        @Override
        public CopyOnWriteSet add(InMemorySpanEventListener listener) {
            return new OneCopyOnWriteSet(listener);
        }

        @Override
        public CopyOnWriteSet remove(InMemorySpanEventListener listener) {
            return this;
        }

        public void onSpanStarted(InMemorySpan span) {
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, String eventName) {
        }

        public void onEventLogged(InMemorySpan span, long epochMicros, Map<String, ?> fields) {
        }

        public void onSpanFinished(InMemorySpan span, long durationMicros) {
        }
    }

    private static interface CopyOnWriteSet
    extends InMemorySpanEventListener {
        public CopyOnWriteSet add(InMemorySpanEventListener var1);

        public CopyOnWriteSet remove(InMemorySpanEventListener var1);
    }
}

